/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeSubtask;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigRegionConnectorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigRegionConnectorMetrics.class);
    private volatile AbstractMetricService metricService;
    private final ConcurrentMap<String, PipeConfigNodeSubtask> subtaskMap = new ConcurrentHashMap<String, PipeConfigNodeSubtask>();
    private final ConcurrentMap<String, Rate> configRateMap = new ConcurrentHashMap<String, Rate>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.subtaskMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String taskID) {
        this.createRate(taskID);
    }

    private void createRate(String taskID) {
        PipeConfigNodeSubtask subtask = (PipeConfigNodeSubtask)((Object)this.subtaskMap.get(taskID));
        this.configRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_CONFIG_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), subtask.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(subtask.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.subtaskMap.keySet()).forEach(this::deregister);
        if (!this.subtaskMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe config region connector metrics, connector map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeRate(taskID);
    }

    private void removeRate(String taskID) {
        PipeConfigNodeSubtask subtask = (PipeConfigNodeSubtask)((Object)this.subtaskMap.get(taskID));
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_CONFIG_TRANSFER.toString(), new String[]{Tag.NAME.toString(), subtask.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(subtask.getCreationTime())});
        this.configRateMap.remove(taskID);
    }

    public void register(PipeConfigNodeSubtask pipeConfigNodeSubtask) {
        String taskID = pipeConfigNodeSubtask.getTaskID();
        this.subtaskMap.putIfAbsent(taskID, pipeConfigNodeSubtask);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.subtaskMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe config region connector metrics, PipeConfigNodeSubtask({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.subtaskMap.remove(taskID);
    }

    public void markConfigEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = (Rate)this.configRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe config region write plan event, PipeConfigNodeSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public static PipeConfigRegionConnectorMetrics getInstance() {
        return PipeConfigNodeSubtaskMetricsHolder.INSTANCE;
    }

    private PipeConfigRegionConnectorMetrics() {
    }

    private static class PipeConfigNodeSubtaskMetricsHolder {
        private static final PipeConfigRegionConnectorMetrics INSTANCE = new PipeConfigRegionConnectorMetrics();

        private PipeConfigNodeSubtaskMetricsHolder() {
        }
    }
}

