/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigPhysicalPlanPatternParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, IoTDBPipePattern> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigPhysicalPlanPatternParseVisitor.class);

    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, IoTDBPipePattern pattern) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateDatabase(DatabaseSchemaPlan createDatabasePlan, IoTDBPipePattern pattern) {
        return pattern.matchPrefixPath(createDatabasePlan.getSchema().getName()) ? Optional.of(createDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAlterDatabase(DatabaseSchemaPlan alterDatabasePlan, IoTDBPipePattern pattern) {
        return pattern.matchPrefixPath(alterDatabasePlan.getSchema().getName()) ? Optional.of(alterDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitDeleteDatabase(DeleteDatabasePlan deleteDatabasePlan, IoTDBPipePattern pattern) {
        return pattern.matchPrefixPath(deleteDatabasePlan.getName()) ? Optional.of(deleteDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan, IoTDBPipePattern pattern) {
        Template template = createSchemaTemplatePlan.getTemplate();
        template.getSchemaMap().keySet().removeIf(measurement -> !pattern.matchTailNode(measurement));
        return !template.getSchemaMap().isEmpty() ? Optional.of(new CreateSchemaTemplatePlan(template.serialize().array())) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitSetSchemaTemplate(CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan, IoTDBPipePattern pattern) {
        return pattern.matchPrefixPath(commitSetSchemaTemplatePlan.getPath()) ? Optional.of(commitSetSchemaTemplatePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeUnsetSchemaTemplate(PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan, IoTDBPipePattern pattern) {
        return pattern.matchPrefixPath(pipeUnsetSchemaTemplatePlan.getPath()) ? Optional.of(pipeUnsetSchemaTemplatePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitExtendSchemaTemplate(ExtendSchemaTemplatePlan extendSchemaTemplatePlan, IoTDBPipePattern pattern) {
        TemplateExtendInfo extendInfo = extendSchemaTemplatePlan.getTemplateExtendInfo();
        int[] filteredIndexes = IntStream.range(0, extendInfo.getMeasurements().size()).filter(index -> pattern.matchTailNode((String)extendInfo.getMeasurements().get(index))).toArray();
        return filteredIndexes.length > 0 ? Optional.of(new ExtendSchemaTemplatePlan(new TemplateExtendInfo(extendInfo.getTemplateName(), IoTDBPipePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getMeasurements()), IoTDBPipePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getDataTypes()), IoTDBPipePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getEncodings()), IoTDBPipePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getCompressors())))) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantUser(AuthorPlan grantUserPlan, IoTDBPipePattern pattern) {
        return this.visitPathRelatedAuthorPlan(grantUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeUser(AuthorPlan revokeUserPlan, IoTDBPipePattern pattern) {
        return this.visitPathRelatedAuthorPlan(revokeUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantRole(AuthorPlan revokeUserPlan, IoTDBPipePattern pattern) {
        return this.visitPathRelatedAuthorPlan(revokeUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeRole(AuthorPlan revokeUserPlan, IoTDBPipePattern pattern) {
        return this.visitPathRelatedAuthorPlan(revokeUserPlan, pattern);
    }

    private Optional<ConfigPhysicalPlan> visitPathRelatedAuthorPlan(AuthorPlan pathRelatedAuthorPlan, IoTDBPipePattern pattern) {
        List<PartialPath> intersectedPaths = pathRelatedAuthorPlan.getNodeNameList().stream().map(arg_0 -> ((IoTDBPipePattern)pattern).getIntersection(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        return !intersectedPaths.isEmpty() ? Optional.of(new AuthorPlan(pathRelatedAuthorPlan.getAuthorType(), pathRelatedAuthorPlan.getUserName(), pathRelatedAuthorPlan.getRoleName(), pathRelatedAuthorPlan.getPassword(), pathRelatedAuthorPlan.getNewPassword(), pathRelatedAuthorPlan.getPermissions(), pathRelatedAuthorPlan.getGrantOpt(), intersectedPaths)) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteTimeSeries(PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan, IoTDBPipePattern pattern) {
        try {
            PathPatternTree intersectedTree = pattern.getIntersection(PathPatternTree.deserialize((ByteBuffer)pipeDeleteTimeSeriesPlan.getPatternTreeBytes()));
            return !intersectedTree.isEmpty() ? Optional.of(new PipeDeleteTimeSeriesPlan(intersectedTree.serialize())) : Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Serialization failed for the delete time series plan in pipe transmission, skip transfer", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteLogicalView(PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan, IoTDBPipePattern pattern) {
        try {
            PathPatternTree intersectedTree = pattern.getIntersection(PathPatternTree.deserialize((ByteBuffer)pipeDeleteLogicalViewPlan.getPatternTreeBytes()));
            return !intersectedTree.isEmpty() ? Optional.of(new PipeDeleteTimeSeriesPlan(intersectedTree.serialize())) : Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Serialization failed for the delete logical view plan in pipe transmission, skip transfer", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeactivateTemplate(PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan, IoTDBPipePattern pattern) {
        Map<PartialPath, List<Template>> newTemplateSetInfo = pipeDeactivateTemplatePlan.getTemplateSetInfo().entrySet().stream().flatMap(entry -> pattern.getIntersection((PartialPath)entry.getKey()).stream().map(partialPath -> new Pair(partialPath, (Object)((List)entry.getValue())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (oldTemplates, newTemplates) -> Stream.of(oldTemplates, newTemplates).flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        return !newTemplateSetInfo.isEmpty() ? Optional.of(new PipeDeactivateTemplatePlan(newTemplateSetInfo)) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitTTL(SetTTLPlan setTTLPlan, IoTDBPipePattern pattern) {
        PartialPath partialPath = new PartialPath(setTTLPlan.getPathPattern());
        List intersectionList = pattern.matchPrefixPath(partialPath.getFullPath()) ? Collections.singletonList(partialPath) : pattern.getIntersection(partialPath);
        return !intersectionList.isEmpty() ? Optional.of(new SetTTLPlan(((PartialPath)intersectionList.get(0)).getNodes(), setTTLPlan.getTTL())) : Optional.empty();
    }
}

