/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime;

import java.util.HashMap;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupStatistics;
import org.apache.iotdb.confignode.manager.load.subscriber.ConsensusGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.RegionGroupStatisticsChangeEvent;
import org.apache.tsfile.utils.Pair;

public class PipeLeaderChangeHandler
implements IClusterStatusSubscriber {
    private final ConfigManager configManager;

    PipeLeaderChangeHandler(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void onConfigRegionGroupLeaderChanged() {
        HashMap<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> virtualChangeMap = new HashMap<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>>();
        virtualChangeMap.put(new TConsensusGroupId(TConsensusGroupType.ConfigRegion, Integer.MIN_VALUE), new Pair((Object)new ConsensusGroupStatistics(Long.MIN_VALUE, Integer.MIN_VALUE), (Object)new ConsensusGroupStatistics(System.nanoTime(), ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId())));
        this.onConsensusGroupStatisticsChanged(new ConsensusGroupStatisticsChangeEvent(virtualChangeMap));
    }

    @Override
    public void onNodeStatisticsChanged(NodeStatisticsChangeEvent event) {
    }

    @Override
    public void onRegionGroupStatisticsChanged(RegionGroupStatisticsChangeEvent event) {
    }

    @Override
    public void onConsensusGroupStatisticsChanged(ConsensusGroupStatisticsChangeEvent event) {
        if (!this.configManager.getPipeManager().getPipeTaskCoordinator().hasAnyPipe()) {
            return;
        }
        HashMap<TConsensusGroupId, Pair<Integer, Integer>> regionGroupToOldAndNewLeaderPairMap = new HashMap<TConsensusGroupId, Pair<Integer, Integer>>();
        event.getDifferentConsensusGroupStatisticsMap().forEach((regionGroupId, pair) -> {
            String databaseName = this.configManager.getPartitionManager().getRegionStorageGroup((TConsensusGroupId)regionGroupId);
            if (Objects.isNull(databaseName) || !databaseName.equals("root.__system") && !databaseName.startsWith("root.__system.")) {
                int newLeaderNodeId;
                int oldLeaderNodeId = pair.left == null ? -1 : ((ConsensusGroupStatistics)pair.left).getLeaderId();
                int n = newLeaderNodeId = pair.right == null ? -1 : ((ConsensusGroupStatistics)pair.right).getLeaderId();
                if (oldLeaderNodeId != newLeaderNodeId) {
                    regionGroupToOldAndNewLeaderPairMap.put((TConsensusGroupId)regionGroupId, (Pair<Integer, Integer>)new Pair((Object)oldLeaderNodeId, (Object)newLeaderNodeId));
                }
            }
        });
        if (regionGroupToOldAndNewLeaderPairMap.isEmpty()) {
            return;
        }
        this.configManager.getProcedureManager().pipeHandleLeaderChange(regionGroupToOldAndNewLeaderPairMap);
    }
}

