/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

public enum RegionGroupStatus {
    Running("Running", 1),
    Available("Available", 2),
    Discouraged("Discouraged", 3),
    Disabled("Disabled", 4);

    private final String status;
    private final int weight;

    private RegionGroupStatus(String status, int weight) {
        this.status = status;
        this.weight = weight;
    }

    public String getStatus() {
        return this.status;
    }

    public static RegionGroupStatus parse(String status) {
        for (RegionGroupStatus regionGroupStatus : RegionGroupStatus.values()) {
            if (!regionGroupStatus.status.equals(status)) continue;
            return regionGroupStatus;
        }
        throw new RuntimeException(String.format("RegionGroupStatus %s doesn't exist.", status));
    }

    public int compare(RegionGroupStatus other) {
        return Integer.compare(this.weight, other.weight);
    }
}

