/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.AbstractStatistics;

public abstract class AbstractLoadCache {
    private static final int MAXIMUM_WINDOW_SIZE = 100;
    protected static final long HEARTBEAT_TIMEOUT_TIME_IN_NS = 20000000000L;
    protected final List<AbstractHeartbeatSample> slidingWindow;
    protected final AtomicReference<AbstractStatistics> currentStatistics = new AtomicReference();

    protected AbstractLoadCache() {
        this.slidingWindow = Collections.synchronizedList(new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(AbstractHeartbeatSample newHeartbeatSample) {
        List<AbstractHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            if (this.getLastSample() == null || this.getLastSample().getSampleLogicalTimestamp() <= newHeartbeatSample.getSampleLogicalTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.remove(0);
            }
        }
    }

    protected AbstractHeartbeatSample getLastSample() {
        return this.slidingWindow.isEmpty() ? null : this.slidingWindow.get(this.slidingWindow.size() - 1);
    }

    public abstract void updateCurrentStatistics();

    public AbstractStatistics getCurrentStatistics() {
        return this.currentStatistics.get();
    }
}

