/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.PartitionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.service.EventService;
import org.apache.iotdb.confignode.manager.load.service.HeartbeatService;
import org.apache.iotdb.confignode.manager.load.service.StatisticsService;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;

public class LoadManager {
    protected final IManager configManager;
    private final RegionBalancer regionBalancer;
    private final PartitionBalancer partitionBalancer;
    private final RouteBalancer routeBalancer;
    protected final LoadCache loadCache;
    protected HeartbeatService heartbeatService;
    private final StatisticsService statisticsService;
    private final EventService eventService;

    public LoadManager(IManager configManager) {
        this.configManager = configManager;
        this.regionBalancer = new RegionBalancer(configManager);
        this.partitionBalancer = new PartitionBalancer(configManager);
        this.routeBalancer = new RouteBalancer(configManager);
        this.loadCache = new LoadCache();
        this.setHeartbeatService(configManager, this.loadCache);
        this.statisticsService = new StatisticsService(this.loadCache);
        this.eventService = new EventService(configManager, this.loadCache, this.routeBalancer);
    }

    protected void setHeartbeatService(IManager configManager, LoadCache loadCache) {
        this.heartbeatService = new HeartbeatService(configManager, loadCache);
    }

    public CreateRegionGroupsPlan allocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        return this.regionBalancer.genRegionGroupsAllocationPlan(allotmentMap, consensusGroupType);
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws DatabaseNotExistsException, NoAvailableRegionGroupException {
        return this.partitionBalancer.allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    public void reBalanceDataPartitionPolicy(String database) {
        this.partitionBalancer.reBalanceDataPartitionPolicy(database);
    }

    public void startLoadServices() {
        this.loadCache.initHeartbeatCache(this.configManager);
        this.heartbeatService.startHeartbeatService();
        this.statisticsService.startLoadStatisticsService();
        this.eventService.startEventService();
        this.partitionBalancer.setupPartitionBalancer();
    }

    public void stopLoadServices() {
        this.heartbeatService.stopHeartbeatService();
        this.statisticsService.stopLoadStatisticsService();
        this.eventService.stopEventService();
        this.loadCache.clearHeartbeatCache();
        this.partitionBalancer.clearPartitionBalancer();
        this.routeBalancer.clearRegionPriority();
    }

    public void clearDataPartitionPolicyTable(String database) {
        this.partitionBalancer.clearDataPartitionPolicyTable(database);
    }

    public NodeStatus getNodeStatus(int nodeId) {
        return this.loadCache.getNodeStatus(nodeId);
    }

    public String getNodeStatusWithReason(int nodeId) {
        return this.loadCache.getNodeStatusWithReason(nodeId);
    }

    public Map<Integer, String> getNodeStatusWithReason() {
        return this.loadCache.getNodeStatusWithReason();
    }

    public List<Integer> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.loadCache.filterConfigNodeThroughStatus(status);
    }

    public List<Integer> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.loadCache.filterDataNodeThroughStatus(status);
    }

    public double getFreeDiskSpace(int dataNodeId) {
        return this.loadCache.getFreeDiskSpace(dataNodeId);
    }

    public Map<Integer, Long> getAllDataNodeLoadScores() {
        return this.loadCache.getAllDataNodeLoadScores();
    }

    public int getLowestLoadDataNode() {
        return this.loadCache.getLowestLoadDataNode();
    }

    public int getLowestLoadDataNode(List<Integer> dataNodeIds) {
        return this.loadCache.getLowestLoadDataNode(dataNodeIds);
    }

    public void forceUpdateNodeCache(NodeType nodeType, int nodeId, NodeHeartbeatSample heartbeatSample) {
        switch (nodeType) {
            case ConfigNode: {
                this.loadCache.cacheConfigNodeHeartbeatSample(nodeId, heartbeatSample);
                break;
            }
            case DataNode: {
                this.loadCache.cacheDataNodeHeartbeatSample(nodeId, heartbeatSample);
                break;
            }
            case AINode: {
                this.loadCache.cacheAINodeHeartbeatSample(nodeId, heartbeatSample);
                break;
            }
        }
        this.loadCache.updateNodeStatistics();
        this.eventService.checkAndBroadcastNodeStatisticsChangeEventIfNecessary();
    }

    public void removeNodeCache(int nodeId) {
        this.loadCache.removeNodeCache(nodeId);
        this.loadCache.updateNodeStatistics();
        this.eventService.checkAndBroadcastNodeStatisticsChangeEventIfNecessary();
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return this.loadCache.getRegionStatus(consensusGroupId, dataNodeId);
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return this.loadCache.getRegionGroupStatus(consensusGroupId);
    }

    public Map<TConsensusGroupId, RegionGroupStatus> getRegionGroupStatus(List<TConsensusGroupId> consensusGroupIds) {
        return this.loadCache.getRegionGroupStatus(consensusGroupIds);
    }

    public List<TConsensusGroupId> filterRegionGroupThroughStatus(RegionGroupStatus ... status) {
        return this.loadCache.filterRegionGroupThroughStatus(status);
    }

    public int countRegionWithSpecifiedStatus(TConsensusGroupType type, RegionStatus ... status) {
        return this.loadCache.countRegionWithSpecifiedStatus(type, status);
    }

    public void forceUpdateRegionGroupCache(Map<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>> heartbeatSampleMap) {
        heartbeatSampleMap.forEach((regionGroupId, regionHeartbeatSampleMap) -> regionHeartbeatSampleMap.forEach((dataNodeId, regionHeartbeatSample) -> this.loadCache.cacheRegionHeartbeatSample((TConsensusGroupId)regionGroupId, (int)dataNodeId, (RegionHeartbeatSample)regionHeartbeatSample, true)));
        this.loadCache.updateRegionGroupStatistics();
        this.eventService.checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
    }

    public void forceUpdateRegionCache(TConsensusGroupId regionGroupId, int dataNodeId, RegionStatus regionStatus) {
        this.loadCache.cacheRegionHeartbeatSample(regionGroupId, dataNodeId, new RegionHeartbeatSample(System.nanoTime(), regionStatus), true);
        this.loadCache.updateRegionGroupStatistics();
        this.eventService.checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
    }

    public void removeRegionCache(TConsensusGroupId regionGroupId, int dataNodeId) {
        this.loadCache.removeRegionCache(regionGroupId, dataNodeId);
        this.loadCache.updateRegionGroupStatistics();
        this.eventService.checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
    }

    public void removeRegionGroupRelatedCache(TConsensusGroupId consensusGroupId) {
        this.loadCache.removeRegionGroupCache(consensusGroupId);
        this.routeBalancer.removeRegionPriority(consensusGroupId);
        this.loadCache.updateRegionGroupStatistics();
        this.loadCache.updateConsensusGroupStatistics();
        this.eventService.checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
        this.eventService.checkAndBroadcastConsensusGroupStatisticsChangeEventIfNecessary();
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap() {
        return this.loadCache.getRegionLeaderMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRegionPriorityMap() {
        return this.routeBalancer.getRegionPriorityMap();
    }

    public int getRegionGroupLeaderCount(int dataNodeId, TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.getRegionLeaderMap().forEach((consensusGroupId, leaderId) -> {
            if (dataNodeId == leaderId && type.equals((Object)consensusGroupId.getType())) {
                result.getAndIncrement();
            }
        });
        return result.get();
    }

    public void waitForRegionGroupReady(List<TConsensusGroupId> regionGroupIds) {
        this.loadCache.waitForLeaderElection(regionGroupIds);
        this.routeBalancer.waitForPriorityUpdate(regionGroupIds);
    }

    public void forceUpdateConsensusGroupCache(Map<TConsensusGroupId, ConsensusGroupHeartbeatSample> heartbeatSampleMap) {
        heartbeatSampleMap.forEach(this.loadCache::cacheConsensusSample);
        this.loadCache.updateConsensusGroupStatistics();
        this.eventService.checkAndBroadcastConsensusGroupStatisticsChangeEventIfNecessary();
    }

    public LoadCache getLoadCache() {
        return this.loadCache;
    }

    public RouteBalancer getRouteBalancer() {
        return this.routeBalancer;
    }

    public EventService getEventService() {
        return this.eventService;
    }
}

