/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetSpaceQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetThrottleQuotaPlan;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.quota.QuotaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterQuotaManager.class);
    private final IManager configManager;
    private final QuotaInfo quotaInfo;
    private final Map<Integer, Long> deviceNum;
    private final Map<Integer, Long> timeSeriesNum;
    private final Map<String, List<Integer>> schemaRegionIdMap;
    private final Map<String, List<Integer>> dataRegionIdMap;
    private final Map<Integer, Long> regionDisk;

    public ClusterQuotaManager(IManager configManager, QuotaInfo quotaInfo) {
        this.configManager = configManager;
        this.quotaInfo = quotaInfo;
        this.deviceNum = new ConcurrentHashMap<Integer, Long>();
        this.timeSeriesNum = new ConcurrentHashMap<Integer, Long>();
        this.schemaRegionIdMap = new HashMap<String, List<Integer>>();
        this.dataRegionIdMap = new HashMap<String, List<Integer>>();
        this.regionDisk = new ConcurrentHashMap<Integer, Long>();
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) {
        if (!this.checkSpaceQuota(req)) {
            return RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)"The used quota exceeds the preset quota. Please set a larger value.");
        }
        try {
            TSStatus response = this.configManager.getConsensusManager().write(new SetSpaceQuotaPlan(req.getDatabase(), req.getSpaceLimit()));
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
                DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.SET_SPACE_QUOTA, req, dataNodeLocationMap);
                CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
                return RpcUtils.squashResponseStatusList((List)clientHandler.getResponseList());
            }
            return response;
        }
        catch (ConsensusException e) {
            LOGGER.warn(String.format("Unexpected error happened while setting space quota on database: %s ", req.getDatabase()), (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    private boolean checkSpaceQuota(TSetSpaceQuotaReq req) {
        for (String database : req.getDatabase()) {
            if (!this.quotaInfo.getSpaceQuotaLimit().containsKey(database)) continue;
            TSpaceQuota spaceQuota = this.quotaInfo.getSpaceQuotaUsage().get(database);
            if (req.getSpaceLimit().getDeviceNum() != -1L && req.getSpaceLimit().getDeviceNum() != 0L && spaceQuota.getDeviceNum() > req.getSpaceLimit().getDeviceNum()) {
                return false;
            }
            if (req.getSpaceLimit().getTimeserieNum() != -1L && req.getSpaceLimit().getTimeserieNum() != 0L && spaceQuota.getTimeserieNum() > req.getSpaceLimit().getTimeserieNum()) {
                return false;
            }
            if (req.getSpaceLimit().getDiskSize() == -1L || req.getSpaceLimit().getDiskSize() == 0L || spaceQuota.getDiskSize() <= req.getSpaceLimit().getDiskSize()) continue;
            return false;
        }
        return true;
    }

    public TSpaceQuotaResp showSpaceQuota(List<String> databases) {
        TSpaceQuotaResp showSpaceQuotaResp = new TSpaceQuotaResp();
        if (databases.isEmpty()) {
            showSpaceQuotaResp.setSpaceQuota(this.quotaInfo.getSpaceQuotaLimit());
            showSpaceQuotaResp.setSpaceQuotaUsage(this.quotaInfo.getSpaceQuotaUsage());
        } else if (!this.quotaInfo.getSpaceQuotaLimit().isEmpty()) {
            HashMap<String, TSpaceQuota> spaceQuotaMap = new HashMap<String, TSpaceQuota>();
            HashMap<String, TSpaceQuota> spaceQuotaUsageMap = new HashMap<String, TSpaceQuota>();
            for (String database : databases) {
                if (!this.quotaInfo.getSpaceQuotaLimit().containsKey(database)) continue;
                spaceQuotaMap.put(database, this.quotaInfo.getSpaceQuotaLimit().get(database));
                spaceQuotaUsageMap.put(database, this.quotaInfo.getSpaceQuotaUsage().get(database));
            }
            showSpaceQuotaResp.setSpaceQuota(spaceQuotaMap);
            showSpaceQuotaResp.setSpaceQuotaUsage(spaceQuotaUsageMap);
        }
        showSpaceQuotaResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return showSpaceQuotaResp;
    }

    public TSpaceQuotaResp getSpaceQuota() {
        TSpaceQuotaResp spaceQuotaResp = new TSpaceQuotaResp();
        if (!this.quotaInfo.getSpaceQuotaLimit().isEmpty()) {
            spaceQuotaResp.setSpaceQuota(this.quotaInfo.getSpaceQuotaLimit());
        }
        spaceQuotaResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return spaceQuotaResp;
    }

    public boolean hasSpaceQuotaLimit() {
        return this.quotaInfo.getSpaceQuotaLimit().keySet().isEmpty();
    }

    public List<Integer> getSchemaRegionIds() {
        ArrayList<Integer> schemaRegionIds = new ArrayList<Integer>();
        this.getPartitionManager().getSchemaRegionIds(new ArrayList<String>(this.quotaInfo.getSpaceQuotaLimit().keySet()), this.schemaRegionIdMap);
        this.schemaRegionIdMap.values().forEach(schemaRegionIds::addAll);
        return schemaRegionIds;
    }

    public List<Integer> getDataRegionIds() {
        ArrayList<Integer> dataRegionIds = new ArrayList<Integer>();
        this.getPartitionManager().getDataRegionIds(new ArrayList<String>(this.quotaInfo.getSpaceQuotaLimit().keySet()), this.dataRegionIdMap);
        this.dataRegionIdMap.values().forEach(dataRegionIds::addAll);
        return dataRegionIds;
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) {
        try {
            TSStatus response = this.configManager.getConsensusManager().write(new SetThrottleQuotaPlan(req.getUserName(), req.getThrottleQuota()));
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
                DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.SET_THROTTLE_QUOTA, req, dataNodeLocationMap);
                CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
                return RpcUtils.squashResponseStatusList((List)clientHandler.getResponseList());
            }
            return response;
        }
        catch (ConsensusException e) {
            LOGGER.warn(String.format("Unexpected error happened while setting throttle quota on user: %s ", req.getUserName()), (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public TThrottleQuotaResp showThrottleQuota(TShowThrottleReq req) {
        TThrottleQuotaResp throttleQuotaResp = new TThrottleQuotaResp();
        if (req.getUserName() == null) {
            throttleQuotaResp.setThrottleQuota(this.quotaInfo.getThrottleQuotaLimit());
        } else {
            HashMap<String, TThrottleQuota> throttleLimit = new HashMap<String, TThrottleQuota>();
            throttleLimit.put(req.getUserName(), this.quotaInfo.getThrottleQuotaLimit().get(req.getUserName()) == null ? new TThrottleQuota() : this.quotaInfo.getThrottleQuotaLimit().get(req.getUserName()));
            throttleQuotaResp.setThrottleQuota(throttleLimit);
        }
        throttleQuotaResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return throttleQuotaResp;
    }

    public TThrottleQuotaResp getThrottleQuota() {
        TThrottleQuotaResp throttleQuotaResp = new TThrottleQuotaResp();
        if (!this.quotaInfo.getThrottleQuotaLimit().isEmpty()) {
            throttleQuotaResp.setThrottleQuota(this.quotaInfo.getThrottleQuotaLimit());
        }
        throttleQuotaResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return throttleQuotaResp;
    }

    public Map<String, TSpaceQuota> getSpaceQuotaUsage() {
        return this.quotaInfo.getSpaceQuotaUsage();
    }

    public Map<Integer, Long> getDeviceNum() {
        return this.deviceNum;
    }

    public Map<Integer, Long> getTimeSeriesNum() {
        return this.timeSeriesNum;
    }

    public Map<Integer, Long> getRegionDisk() {
        return this.regionDisk;
    }

    public void updateSpaceQuotaUsage() {
        AtomicLong deviceCount = new AtomicLong();
        AtomicLong timeSeriesCount = new AtomicLong();
        for (Map.Entry<String, List<Integer>> entry : this.schemaRegionIdMap.entrySet()) {
            deviceCount.set(0L);
            timeSeriesCount.set(0L);
            entry.getValue().forEach(schemaRegionId -> {
                if (this.deviceNum.containsKey(schemaRegionId)) {
                    deviceCount.addAndGet(deviceCount.get() + this.deviceNum.get(schemaRegionId));
                }
                if (this.timeSeriesNum.containsKey(schemaRegionId)) {
                    timeSeriesCount.addAndGet(timeSeriesCount.get() + this.timeSeriesNum.get(schemaRegionId));
                }
            });
            this.quotaInfo.getSpaceQuotaUsage().get(entry.getKey()).setDeviceNum(deviceCount.get());
            this.quotaInfo.getSpaceQuotaUsage().get(entry.getKey()).setTimeserieNum(timeSeriesCount.get());
        }
        AtomicLong regionDiskCount = new AtomicLong();
        for (Map.Entry<String, List<Integer>> entry : this.dataRegionIdMap.entrySet()) {
            regionDiskCount.set(0L);
            entry.getValue().forEach(dataRegionId -> {
                if (this.regionDisk.containsKey(dataRegionId)) {
                    regionDiskCount.addAndGet(this.regionDisk.get(dataRegionId));
                }
            });
            this.quotaInfo.getSpaceQuotaUsage().get(entry.getKey()).setDiskSize(regionDiskCount.get());
        }
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

