/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc.subscription;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSchemaRegionUsingTemplateRPCHandler
extends DataNodeAsyncRequestRPCHandler<TCheckSchemaRegionUsingTemplateResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSchemaRegionUsingTemplateRPCHandler.class);

    public CheckSchemaRegionUsingTemplateRPCHandler(CnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TCheckSchemaRegionUsingTemplateResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TCheckSchemaRegionUsingTemplateResp response) {
        TSStatus tsStatus = response.getStatus();
        this.responseMap.put(this.requestId, response);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully check schema region using template on DataNode: {}", this.targetNode);
        } else if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.error("Failed to check schema region using template on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        } else {
            LOGGER.error("Failed to check schema region using template on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Count paths using template error on DataNode: {id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}" + e.getMessage();
        LOGGER.error(errorMsg);
        this.countDownLatch.countDown();
        TCheckSchemaRegionUsingTemplateResp resp = new TCheckSchemaRegionUsingTemplateResp();
        resp.setStatus(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.responseMap.put(this.requestId, resp);
    }
}

