/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeTSStatusRPCHandler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdateRPCHandler
extends DataNodeTSStatusRPCHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUpdateRPCHandler.class);

    public SchemaUpdateRPCHandler(CnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TSStatus> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    @Override
    public void onComplete(TSStatus tsStatus) {
        this.responseMap.put(this.requestId, tsStatus);
        LOGGER.info("{} for {} receives: {}", new Object[]{this.requestType, this.requestId, tsStatus});
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        } else if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.warn("Failed to {} on DataNode {}, {}", new Object[]{this.requestType, this.formattedTargetLocation, tsStatus});
        } else {
            LOGGER.warn("Failed to {} on DataNode {}, {}", new Object[]{this.requestType, this.formattedTargetLocation, tsStatus});
        }
        this.countDownLatch.countDown();
    }

    @Override
    public void onError(Exception e) {
        String errorMsg = this.requestType + " error on DataNode: {id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}" + e.getMessage();
        LOGGER.warn(errorMsg);
        this.countDownLatch.countDown();
        this.responseMap.put(this.requestId, new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
    }
}

