/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePushMetaRPCHandler
extends DataNodeAsyncRequestRPCHandler<TPushPipeMetaResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePushMetaRPCHandler.class);

    public PipePushMetaRPCHandler(CnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TPushPipeMetaResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TPushPipeMetaResp response) {
        this.responseMap.put(this.requestId, response);
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.info("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        } else {
            LOGGER.error("Failed to {} on DataNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.nodeLocationMap.remove(this.requestId);
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + this.requestType + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        LOGGER.error(errorMsg, (Throwable)e);
        this.responseMap.put(this.requestId, new TPushPipeMetaResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_PUSH_META_ERROR, (String)errorMsg)));
        this.countDownLatch.countDown();
    }
}

