/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.BackFloatTVList;
import org.apache.iotdb.db.utils.datastructure.QuickFloatTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimFloatTVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.TsPrimitiveType;

public abstract class FloatTVList
extends TVList {
    protected List<float[]> values = new ArrayList<float[]>();

    FloatTVList() {
    }

    public static FloatTVList newList() {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickFloatTVList();
            }
            case BACKWARD: {
                return new BackFloatTVList();
            }
        }
        return new TimFloatTVList();
    }

    @Override
    public FloatTVList clone() {
        FloatTVList cloneList = FloatTVList.newList();
        this.cloneAs(cloneList);
        for (float[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private float[] cloneValue(float[] array) {
        float[] cloneArray = new float[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void putFloat(long timestamp, float value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.maxTime = Math.max(this.maxTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.rowCount;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public float getFloat(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, float value) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (float[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((float[])this.getPrimitiveArraysByType(TSDataType.FLOAT));
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(this.getFloat(index))));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        float value = this.getFloat(index);
        if (!(Float.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            value = MathUtils.roundWithGivenPrecision(value, (int)floatPrecision);
        }
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(value)));
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        for (int i = 0; i < this.rowCount; ++i) {
            if (ModificationUtils.isPointDeleted(this.getTime(i), deletionList, deleteCursor) || i != this.rowCount - 1 && this.getTime(i) == this.getTime(i + 1)) continue;
            builder.getTimeColumnBuilder().writeLong(this.getTime(i));
            builder.getColumnBuilder(0).writeFloat(this.roundValueWithGivenPrecision(this.getFloat(i), floatPrecision, encoding));
            builder.declarePosition();
        }
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putFloats(long[] time, float[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            int nullCnt = this.dropNullValThenUpdateMaxTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMaxTimeAndSorted(time, start, end);
        }
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMaxTimeAndSorted(long[] time, float[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            this.maxTime = Math.max(this.maxTime, time[tIdx]);
            if (!inputSorted || tIdx <= 0 || time[tIdx - 1] <= time[tIdx]) continue;
            inputSorted = false;
        }
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.FLOAT;
    }

    @Override
    public int serializedSize() {
        return 5 + this.rowCount * 12;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.FLOAT, buffer);
        buffer.putInt(this.rowCount);
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            buffer.putLong(this.getTime(rowIdx));
            buffer.putFloat(this.getFloat(rowIdx));
        }
    }

    public static FloatTVList deserialize(DataInputStream stream) throws IOException {
        FloatTVList tvList = FloatTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        float[] values = new float[rowCount];
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = stream.readFloat();
        }
        tvList.putFloats(times, values, null, 0, rowCount);
        return tvList;
    }
}

