/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTabletQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTabletBatchEvents;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.apache.tsfile.write.record.Tablet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeTabletEventBatch
extends SubscriptionPipeEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeTabletEventBatch.class);
    private static final long READ_TABLET_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionReadTabletBufferSize();
    private final List<EnrichedEvent> enrichedEvents = new ArrayList<EnrichedEvent>();
    private final List<Tablet> tablets = new ArrayList<Tablet>();
    private long firstEventProcessingTime = Long.MIN_VALUE;
    private long totalBufferSize = 0L;

    public SubscriptionPipeTabletEventBatch(int regionId, SubscriptionPrefetchingTabletQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        super(regionId, prefetchingQueue, maxDelayInMs, maxBatchSizeInBytes);
    }

    @Override
    public synchronized boolean onEvent(Consumer<SubscriptionEvent> consumer) {
        if (this.shouldEmit() && !this.enrichedEvents.isEmpty()) {
            if (Objects.isNull(this.events)) {
                this.events = this.generateSubscriptionEvents();
            }
            if (Objects.nonNull(this.events)) {
                this.events.forEach(consumer);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean onEvent(@NonNull EnrichedEvent event, Consumer<SubscriptionEvent> consumer) {
        if (event instanceof TabletInsertionEvent) {
            this.onEventInternal((TabletInsertionEvent)event);
        }
        return this.onEvent(consumer);
    }

    @Override
    public synchronized void cleanUp() {
        for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
            enrichedEvent.clearReferenceCount(this.getClass().getName());
        }
        this.enrichedEvents.clear();
        this.tablets.clear();
    }

    public synchronized void ack() {
        for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
            enrichedEvent.decreaseReferenceCount(this.getClass().getName(), true);
        }
    }

    private List<SubscriptionEvent> generateSubscriptionEvents() {
        if (this.tablets.isEmpty()) {
            return null;
        }
        SubscriptionCommitContext commitContext = this.prefetchingQueue.generateSubscriptionCommitContext();
        ArrayList<SubscriptionPollResponse> responses = new ArrayList<SubscriptionPollResponse>();
        ArrayList<Tablet> currentTablets = new ArrayList<Tablet>();
        long currentTotalBufferSize = 0L;
        for (Tablet tablet : this.tablets) {
            long bufferSize = PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet);
            if (bufferSize > READ_TABLET_BUFFER_SIZE) {
                LOGGER.warn("Detect large tablet with {} byte(s).", (Object)bufferSize);
                responses.add(new SubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.singletonList(tablet), responses.size() + 1), commitContext));
                continue;
            }
            if (currentTotalBufferSize + bufferSize > READ_TABLET_BUFFER_SIZE) {
                responses.add(new SubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new ArrayList(currentTablets), responses.size() + 1), commitContext));
                currentTablets.clear();
                currentTotalBufferSize = 0L;
            }
            currentTablets.add(tablet);
            currentTotalBufferSize += bufferSize;
        }
        responses.add(new SubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new ArrayList(currentTablets), -this.tablets.size()), commitContext));
        return Collections.singletonList(new SubscriptionEvent((SubscriptionPipeEvents)new SubscriptionPipeTabletBatchEvents(this), responses));
    }

    private void onEventInternal(TabletInsertionEvent event) {
        this.constructBatch(event);
        this.enrichedEvents.add((EnrichedEvent)event);
        if (this.firstEventProcessingTime == Long.MIN_VALUE) {
            this.firstEventProcessingTime = System.currentTimeMillis();
        }
    }

    private void constructBatch(TabletInsertionEvent event) {
        List<Tablet> currentTablets = this.convertToTablets(event);
        if (currentTablets.isEmpty()) {
            return;
        }
        this.tablets.addAll(currentTablets);
        this.totalBufferSize += currentTablets.stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L).longValue();
    }

    private boolean shouldEmit() {
        return this.totalBufferSize >= this.maxBatchSizeInBytes || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    private List<Tablet> convertToTablets(TabletInsertionEvent tabletInsertionEvent) {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            return ((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).convertToTablets();
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            return Collections.singletonList(((PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet());
        }
        LOGGER.warn("SubscriptionPipeTabletEventBatch {} only support convert PipeInsertNodeTabletInsertionEvent or PipeRawTabletInsertionEvent to tablet. Ignore {}.", (Object)this, (Object)tabletInsertionEvent);
        return Collections.emptyList();
    }

    public String toString() {
        return "SubscriptionPipeTabletEventBatch" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("enrichedEvents", SubscriptionPipeTabletEventBatch.formatEnrichedEvents(this.enrichedEvents, 4));
        coreReportMessage.put("size of tablets", String.valueOf(this.tablets.size()));
        coreReportMessage.put("firstEventProcessingTime", String.valueOf(this.firstEventProcessingTime));
        coreReportMessage.put("totalBufferSize", String.valueOf(this.totalBufferSize));
        return coreReportMessage;
    }

    private static String formatEnrichedEvents(List<EnrichedEvent> enrichedEvents, int threshold) {
        List eventMessageList = enrichedEvents.stream().limit(threshold).map(EnrichedEvent::coreReportMessage).collect(Collectors.toList());
        if (eventMessageList.size() > threshold) {
            eventMessageList.add(String.format("omit the remaining %s event(s)...", eventMessageList.size() - threshold));
        }
        return eventMessageList.toString();
    }

    public int getPipeEventCount() {
        return this.enrichedEvents.size();
    }
}

