/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBlockingPendingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatches;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEmptyEvent;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.ErrorPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionPrefetchingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingQueue.class);
    private final String brokerId;
    private final String topicName;
    private final SubscriptionBlockingPendingQueue inputPendingQueue;
    private final AtomicLong commitIdGenerator;
    protected final LinkedBlockingQueue<SubscriptionEvent> prefetchingQueue;
    protected final Map<Pair<String, SubscriptionCommitContext>, SubscriptionEvent> inFlightEvents;
    protected final SubscriptionPipeEventBatches batches;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile boolean isCompleted = false;
    private volatile boolean isClosed = false;

    public SubscriptionPrefetchingQueue(String brokerId, String topicName, SubscriptionBlockingPendingQueue inputPendingQueue, AtomicLong commitIdGenerator, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.brokerId = brokerId;
        this.topicName = topicName;
        this.inputPendingQueue = inputPendingQueue;
        this.commitIdGenerator = commitIdGenerator;
        this.prefetchingQueue = new LinkedBlockingQueue();
        this.inFlightEvents = new ConcurrentHashMap<Pair<String, SubscriptionCommitContext>, SubscriptionEvent>();
        this.batches = new SubscriptionPipeEventBatches(this, maxDelayInMs, maxBatchSizeInBytes);
    }

    public void cleanUp() {
        this.acquireWriteLock();
        try {
            this.cleanUpInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected void cleanUpInternal() {
        this.batches.cleanUp();
        this.prefetchingQueue.forEach(SubscriptionEvent::cleanUp);
        this.prefetchingQueue.clear();
        this.inFlightEvents.values().forEach(SubscriptionEvent::cleanUp);
        this.inFlightEvents.clear();
    }

    protected void acquireReadLock() {
        this.lock.readLock().lock();
    }

    protected void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    protected void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    public SubscriptionEvent poll(String consumerId) {
        this.acquireReadLock();
        try {
            SubscriptionEvent subscriptionEvent = this.isClosed() ? null : this.pollInternal(consumerId);
            return subscriptionEvent;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public SubscriptionEvent pollInternal(String consumerId) {
        if (this.prefetchingQueue.isEmpty()) {
            this.tryPrefetch(true);
        }
        long size = this.prefetchingQueue.size();
        long count = 0L;
        try {
            SubscriptionEvent event;
            while (count++ < size && Objects.nonNull(event = this.prefetchingQueue.poll(SubscriptionConfig.getInstance().getSubscriptionPollMaxBlockingTimeMs(), TimeUnit.MILLISECONDS))) {
                if (event.isCommitted()) {
                    LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} poll committed event {} from prefetching queue (broken invariant), remove it", (Object)this, (Object)event);
                    continue;
                }
                if (!event.pollable()) {
                    LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} poll non-pollable event {} from prefetching queue (broken invariant), nack and remove it", (Object)this, (Object)event);
                    event.nack();
                    continue;
                }
                event.recordLastPolledTimestamp();
                this.inFlightEvents.put((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)event.getCommitContext()), event);
                event.recordLastPolledConsumerId(consumerId);
                return event;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} interrupted while polling events.", (Object)this, (Object)e);
        }
        return null;
    }

    public void executePrefetch() {
        this.acquireReadLock();
        try {
            if (this.isClosed()) {
                return;
            }
            this.executePrefetchInternal();
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void executePrefetchInternal() {
        this.tryPrefetch(false);
        for (Pair pair : ImmutableSet.copyOf(this.inFlightEvents.keySet())) {
            this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)pair, (key, ev) -> {
                if (Objects.isNull(ev)) {
                    return null;
                }
                if (ev.isCommitted()) {
                    ev.cleanUp();
                    return null;
                }
                if (ev.eagerlyPollable()) {
                    ev.nack();
                    this.enqueueEventToPrefetchingQueue((SubscriptionEvent)ev);
                    return null;
                }
                if (ev.pollable()) {
                    ev.nack();
                    this.enqueueEventToPrefetchingQueue((SubscriptionEvent)ev);
                    LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} recycle event {} from in flight events, nack and enqueue it to prefetching queue", (Object)this, ev);
                    return null;
                }
                try {
                    ev.prefetchRemainingResponses();
                    ev.trySerializeRemainingResponses();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ev;
            });
        }
    }

    protected void enqueueEventToPrefetchingQueue(SubscriptionEvent event) {
        event.trySerializeCurrentResponse();
        this.prefetchingQueue.add(event);
    }

    private void tryPrefetch(boolean onEventIfEmpty) {
        while (!this.inputPendingQueue.isEmpty()) {
            Event event = UserDefinedEnrichedEvent.maybeOf(this.inputPendingQueue.waitedPoll());
            if (Objects.isNull(event)) continue;
            if (!(event instanceof EnrichedEvent)) {
                LOGGER.warn("Subscription: SubscriptionPrefetchingQueue {} only support prefetch EnrichedEvent. Ignore {}.", (Object)this, (Object)event);
                continue;
            }
            if (event instanceof PipeTerminateEvent) {
                PipeTerminateEvent terminateEvent = (PipeTerminateEvent)event;
                terminateEvent.addOnCommittedHook(() -> {
                    this.markCompleted();
                    return null;
                });
                ((PipeTerminateEvent)event).decreaseReferenceCount(SubscriptionPrefetchingQueue.class.getName(), true);
                LOGGER.info("Subscription: SubscriptionPrefetchingQueue {} commit PipeTerminateEvent {}", (Object)this, (Object)terminateEvent);
                continue;
            }
            if (event instanceof TabletInsertionEvent) {
                if (!this.onEvent((TabletInsertionEvent)event)) continue;
                return;
            }
            if (event instanceof PipeTsFileInsertionEvent) {
                if (!this.onEvent((PipeTsFileInsertionEvent)event)) continue;
                return;
            }
            LOGGER.info("Subscription: SubscriptionPrefetchingQueue {} ignore EnrichedEvent {} when prefetching.", (Object)this, (Object)event);
            if (!this.onEvent()) continue;
            return;
        }
        if (onEventIfEmpty) {
            this.onEvent();
        }
    }

    protected abstract boolean onEvent(TsFileInsertionEvent var1);

    protected boolean onEvent(TabletInsertionEvent event) {
        return this.batches.onEvent((EnrichedEvent)event, this::enqueueEventToPrefetchingQueue);
    }

    protected boolean onEvent() {
        return this.batches.onEvent(this::enqueueEventToPrefetchingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ack(String consumerId, SubscriptionCommitContext commitContext) {
        this.acquireReadLock();
        try {
            boolean bl = !this.isClosed() && this.ackInternal(consumerId, commitContext);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean ackInternal(String consumerId, SubscriptionCommitContext commitContext) {
        AtomicBoolean acked = new AtomicBoolean(false);
        this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                LOGGER.warn("Subscription: subscription commit context {} does not exist, it may have been committed or something unexpected happened, prefetching queue: {}", (Object)commitContext, (Object)this);
                return null;
            }
            if (ev.isCommitted()) {
                LOGGER.warn("Subscription: subscription event {} is committed, subscription commit context {}, prefetching queue: {}", new Object[]{ev, commitContext, this});
                ev.cleanUp();
                return null;
            }
            if (!ev.isCommittable()) {
                LOGGER.warn("Subscription: subscription event {} is not committable, subscription commit context {}, prefetching queue: {}", new Object[]{ev, commitContext, this});
                return ev;
            }
            String consumerGroupId = commitContext.getConsumerGroupId();
            if (!Objects.equals(consumerGroupId, this.brokerId)) {
                LOGGER.warn("inconsistent consumer group when acking event, current: {}, incoming: {}, consumer id: {}, event commit context: {}, prefetching queue: {}, commit it anyway...", new Object[]{this.brokerId, consumerGroupId, consumerId, commitContext, this});
            }
            ev.ack();
            ev.recordCommittedTimestamp();
            acked.set(true);
            ev.cleanUp();
            return null;
        });
        return acked.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nack(String consumerId, SubscriptionCommitContext commitContext) {
        this.acquireReadLock();
        try {
            boolean bl = !this.isClosed() && this.nackInternal(consumerId, commitContext);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean nackInternal(String consumerId, SubscriptionCommitContext commitContext) {
        AtomicBoolean nacked = new AtomicBoolean(false);
        this.inFlightEvents.compute((Pair<String, SubscriptionCommitContext>)new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                LOGGER.warn("Subscription: subscription commit context [{}] does not exist, it may have been committed or something unexpected happened, prefetching queue: {}", (Object)commitContext, (Object)this);
                return null;
            }
            String consumerGroupId = commitContext.getConsumerGroupId();
            if (!Objects.equals(consumerGroupId, this.brokerId)) {
                LOGGER.warn("inconsistent consumer group when nacking event, current: {}, incoming: {}, consumer id: {}, event commit context: {}, prefetching queue: {}, commit it anyway...", new Object[]{this.brokerId, consumerGroupId, consumerId, commitContext, this});
            }
            ev.nack();
            nacked.set(true);
            return ev;
        });
        return nacked.get();
    }

    public SubscriptionCommitContext generateSubscriptionCommitContext() {
        return new SubscriptionCommitContext(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), PipeDataNodeAgent.runtime().getRebootTimes(), this.topicName, this.brokerId, this.commitIdGenerator.getAndIncrement());
    }

    protected SubscriptionEvent generateSubscriptionPollErrorResponse(String errorMessage) {
        return new SubscriptionEvent((SubscriptionPipeEvents)new SubscriptionPipeEmptyEvent(), new SubscriptionPollResponse(SubscriptionPollResponseType.ERROR.getType(), (SubscriptionPollPayload)new ErrorPayload(errorMessage, false), new SubscriptionCommitContext(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), PipeDataNodeAgent.runtime().getRebootTimes(), this.topicName, this.brokerId, -1L)));
    }

    public String getPrefetchingQueueId() {
        return SubscriptionPrefetchingQueue.generatePrefetchingQueueId(this.brokerId, this.topicName);
    }

    public static String generatePrefetchingQueueId(String consumerGroupId, String topicName) {
        return consumerGroupId + "_" + topicName;
    }

    public long getSubscriptionUncommittedEventCount() {
        return this.inFlightEvents.size();
    }

    public long getCurrentCommitId() {
        return this.commitIdGenerator.get();
    }

    public int getPipeEventCount() {
        return this.inputPendingQueue.size() + this.prefetchingQueue.stream().map(SubscriptionEvent::getPipeEventCount).reduce(Integer::sum).orElse(0) + this.inFlightEvents.values().stream().map(SubscriptionEvent::getPipeEventCount).reduce(Integer::sum).orElse(0);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void markClosed() {
        this.isClosed = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void markCompleted() {
        this.isCompleted = true;
    }

    public Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("brokerId", this.brokerId);
        result.put("topicName", this.topicName);
        result.put("size of inputPendingQueue", String.valueOf(this.inputPendingQueue.size()));
        result.put("size of prefetchingQueue", String.valueOf(this.prefetchingQueue.size()));
        result.put("size of inFlightEvents", String.valueOf(this.inFlightEvents.size()));
        result.put("commitIdGenerator", this.commitIdGenerator.toString());
        result.put("isCompleted", String.valueOf(this.isCompleted));
        result.put("isClosed", String.valueOf(this.isClosed));
        return result;
    }

    public Map<String, String> allReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("brokerId", this.brokerId);
        result.put("topicName", this.topicName);
        result.put("size of inputPendingQueue", String.valueOf(this.inputPendingQueue.size()));
        result.put("prefetchingQueue", this.prefetchingQueue.toString());
        result.put("inFlightEvents", this.inFlightEvents.toString());
        result.put("commitIdGenerator", this.commitIdGenerator.toString());
        result.put("isCompleted", String.valueOf(this.isCompleted));
        result.put("isClosed", String.valueOf(this.isClosed));
        return result;
    }
}

