/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.subscription.broker.SubscriptionBroker;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionConnectorSubtask;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionBrokerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionBrokerAgent.class);
    private final Map<String, SubscriptionBroker> consumerGroupIdToSubscriptionBroker = new ConcurrentHashMap<String, SubscriptionBroker>();

    public List<SubscriptionEvent> poll(ConsumerConfig consumerConfig, Set<String> topicNames, long maxBytes) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.poll(consumerId, topicNames, maxBytes);
    }

    public List<SubscriptionEvent> pollTsFile(ConsumerConfig consumerConfig, SubscriptionCommitContext commitContext, long writingOffset) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.pollTsFile(consumerId, commitContext, writingOffset);
    }

    public List<SubscriptionEvent> pollTablets(ConsumerConfig consumerConfig, SubscriptionCommitContext commitContext, int offset) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.pollTablets(consumerId, commitContext, offset);
    }

    public List<SubscriptionCommitContext> commit(ConsumerConfig consumerConfig, List<SubscriptionCommitContext> commitContexts, boolean nack) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.commit(consumerId, commitContexts, nack);
    }

    public boolean isBrokerExist(String consumerGroupId) {
        return this.consumerGroupIdToSubscriptionBroker.containsKey(consumerGroupId);
    }

    public void createBroker(String consumerGroupId) {
        SubscriptionBroker broker = new SubscriptionBroker(consumerGroupId);
        this.consumerGroupIdToSubscriptionBroker.put(consumerGroupId, broker);
        LOGGER.info("Subscription: create broker bound to consumer group [{}]", (Object)consumerGroupId);
    }

    public boolean dropBroker(String consumerGroupId) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return true;
        }
        if (!broker.isEmpty()) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] is not empty when dropping", (Object)consumerGroupId);
            return false;
        }
        this.consumerGroupIdToSubscriptionBroker.remove(consumerGroupId);
        LOGGER.info("Subscription: drop broker bound to consumer group [{}]", (Object)consumerGroupId);
        return true;
    }

    public void bindPrefetchingQueue(SubscriptionConnectorSubtask subtask) {
        String consumerGroupId = subtask.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.bindPrefetchingQueue(subtask.getTopicName(), subtask.getInputPendingQueue());
    }

    public void unbindPrefetchingQueue(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.unbindPrefetchingQueue(topicName);
    }

    public void removePrefetchingQueue(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.removePrefetchingQueue(topicName);
    }

    public void executePrefetch(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.executePrefetch(topicName);
    }

    public int getPipeEventCount(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return 0;
        }
        return broker.getPipeEventCount(topicName);
    }
}

