/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileAnalyzeSchemaMemoryBlock;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileDataCacheMemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileMemoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileMemoryManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final LocalExecutionPlanner QUERY_ENGINE_MEMORY_MANAGER = LocalExecutionPlanner.getInstance();
    public static final long MEMORY_TOTAL_SIZE_FROM_QUERY_IN_BYTES = QUERY_ENGINE_MEMORY_MANAGER.getAllocateMemoryForOperators();
    private static final int MEMORY_ALLOCATE_MAX_RETRIES = CONFIG.getLoadMemoryAllocateMaxRetries();
    private static final long MEMORY_ALLOCATE_RETRY_INTERVAL_IN_MS = CONFIG.getLoadMemoryAllocateRetryIntervalMs();
    private final AtomicLong usedMemorySizeInBytes = new AtomicLong(0L);
    private LoadTsFileDataCacheMemoryBlock dataCacheMemoryBlock;

    private synchronized void forceAllocatedFromQuery(long sizeInBytes) throws LoadRuntimeOutOfMemoryException {
        for (int i = 0; i < MEMORY_ALLOCATE_MAX_RETRIES; ++i) {
            if (QUERY_ENGINE_MEMORY_MANAGER.forceAllocateFreeMemoryForOperators(sizeInBytes)) {
                this.usedMemorySizeInBytes.addAndGet(sizeInBytes);
                return;
            }
            try {
                this.wait(MEMORY_ALLOCATE_RETRY_INTERVAL_IN_MS);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("forceAllocate: interrupted while waiting for available memory", (Throwable)e);
            }
        }
        throw new LoadRuntimeOutOfMemoryException(String.format("forceAllocate: failed to allocate memory from query engine after %s retries, total query memory %s bytes, current available memory for load %s bytes, current load used memory size %s bytes, load requested memory size %s bytes", MEMORY_ALLOCATE_MAX_RETRIES, QUERY_ENGINE_MEMORY_MANAGER.getAllocateMemoryForOperators(), QUERY_ENGINE_MEMORY_MANAGER.getFreeMemoryForLoadTsFile(), this.usedMemorySizeInBytes.get(), sizeInBytes));
    }

    public synchronized long tryAllocateFromQuery(long sizeInBytes) {
        long actuallyAllocateMemoryInBytes = Math.max(0L, QUERY_ENGINE_MEMORY_MANAGER.tryAllocateFreeMemoryForOperators(sizeInBytes));
        this.usedMemorySizeInBytes.addAndGet(actuallyAllocateMemoryInBytes);
        return actuallyAllocateMemoryInBytes;
    }

    public synchronized void releaseToQuery(long sizeInBytes) {
        this.usedMemorySizeInBytes.addAndGet(-sizeInBytes);
        QUERY_ENGINE_MEMORY_MANAGER.releaseToFreeMemoryForOperators(sizeInBytes);
        this.notifyAll();
    }

    public synchronized LoadTsFileAnalyzeSchemaMemoryBlock allocateAnalyzeSchemaMemoryBlock(long sizeInBytes) throws LoadRuntimeOutOfMemoryException {
        try {
            this.forceAllocatedFromQuery(sizeInBytes);
        }
        catch (LoadRuntimeOutOfMemoryException e) {
            if (this.dataCacheMemoryBlock != null && this.dataCacheMemoryBlock.doShrink(sizeInBytes)) {
                return new LoadTsFileAnalyzeSchemaMemoryBlock(sizeInBytes);
            }
            throw e;
        }
        return new LoadTsFileAnalyzeSchemaMemoryBlock(sizeInBytes);
    }

    public synchronized LoadTsFileDataCacheMemoryBlock allocateDataCacheMemoryBlock() throws LoadRuntimeOutOfMemoryException {
        if (this.dataCacheMemoryBlock == null) {
            long actuallyAllocateMemoryInBytes = this.tryAllocateFromQuery(MEMORY_TOTAL_SIZE_FROM_QUERY_IN_BYTES >> 2);
            this.dataCacheMemoryBlock = new LoadTsFileDataCacheMemoryBlock(actuallyAllocateMemoryInBytes);
            LOGGER.info("Create Data Cache Memory Block {}, allocate memory {}", (Object)this.dataCacheMemoryBlock, (Object)actuallyAllocateMemoryInBytes);
        }
        this.dataCacheMemoryBlock.updateReferenceCount(1);
        return this.dataCacheMemoryBlock;
    }

    public synchronized void releaseDataCacheMemoryBlock() {
        this.dataCacheMemoryBlock.updateReferenceCount(-1);
        if (this.dataCacheMemoryBlock.getReferenceCount() == 0) {
            LOGGER.info("Release Data Cache Memory Block {}", (Object)this.dataCacheMemoryBlock);
            this.dataCacheMemoryBlock.close();
            this.dataCacheMemoryBlock = null;
        }
    }

    public long getUsedMemorySizeInBytes() {
        return this.usedMemorySizeInBytes.get();
    }

    public long getDataCacheUsedMemorySizeInBytes() {
        return this.dataCacheMemoryBlock == null ? 0L : this.dataCacheMemoryBlock.getMemoryUsageInBytes();
    }

    public long getDataCacheLimitedMemorySizeInBytes() {
        return this.dataCacheMemoryBlock == null ? 0L : this.dataCacheMemoryBlock.getLimitedMemorySizeInBytes();
    }

    private LoadTsFileMemoryManager() {
    }

    public static LoadTsFileMemoryManager getInstance() {
        return LoadTsFileMemoryManagerHolder.INSTANCE;
    }

    public static class LoadTsFileMemoryManagerHolder {
        private static final LoadTsFileMemoryManager INSTANCE = new LoadTsFileMemoryManager();
    }
}

