/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class WritableMemChunkGroup
implements IWritableMemChunkGroup {
    private Map<String, IWritableMemChunk> memChunkMap = new HashMap<String, IWritableMemChunk>();

    @Override
    public boolean writeValuesWithFlushCheck(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        boolean flushFlag = false;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i));
            flushFlag |= memChunk.writeWithFlushCheck(times, columns[i], bitMaps == null ? null : bitMaps[i], schemaList.get(i).getType(), start, end);
        }
        return flushFlag;
    }

    private IWritableMemChunk createMemChunkIfNotExistAndGet(IMeasurementSchema schema) {
        return this.memChunkMap.computeIfAbsent(schema.getMeasurementId(), k -> new WritableMemChunk(schema));
    }

    @Override
    public void release() {
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            memChunk.release();
        }
    }

    @Override
    public long count() {
        long count = 0L;
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            count += memChunk.count();
        }
        return count;
    }

    @Override
    public boolean contains(String measurement) {
        return this.memChunkMap.containsKey(measurement);
    }

    @Override
    public boolean writeWithFlushCheck(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        boolean flushFlag = false;
        for (int i = 0; i < objectValue.length; ++i) {
            if (objectValue[i] == null) continue;
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i));
            flushFlag |= memChunk.writeWithFlushCheck(insertTime, objectValue[i]);
        }
        return flushFlag;
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        return this.memChunkMap;
    }

    @Override
    public int delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        int deletedPointsNumber = 0;
        String targetMeasurement = originalPath.getMeasurement();
        if (PathPatternUtil.hasWildcard((String)targetMeasurement)) {
            Iterator<Map.Entry<String, IWritableMemChunk>> iter = this.memChunkMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, IWritableMemChunk> entry = iter.next();
                if (!PathPatternUtil.isNodeMatch((String)targetMeasurement, (String)entry.getKey())) continue;
                IWritableMemChunk chunk = entry.getValue();
                if (startTimestamp == Long.MIN_VALUE && endTimestamp == Long.MAX_VALUE) {
                    iter.remove();
                    deletedPointsNumber = (int)((long)deletedPointsNumber + chunk.count());
                    chunk.release();
                    continue;
                }
                deletedPointsNumber += chunk.delete(startTimestamp, endTimestamp);
                if (chunk.count() != 0L) continue;
                iter.remove();
            }
        } else {
            IWritableMemChunk chunk = this.memChunkMap.get(targetMeasurement);
            if (chunk != null) {
                if (startTimestamp == Long.MIN_VALUE && endTimestamp == Long.MAX_VALUE) {
                    this.memChunkMap.remove(targetMeasurement);
                    deletedPointsNumber = (int)((long)deletedPointsNumber + chunk.count());
                    chunk.release();
                } else {
                    deletedPointsNumber += chunk.delete(startTimestamp, endTimestamp);
                    if (chunk.count() == 0L) {
                        this.memChunkMap.remove(targetMeasurement);
                    }
                }
            }
        }
        return deletedPointsNumber;
    }

    @Override
    public long getCurrentTVListSize(String measurement) {
        if (!this.memChunkMap.containsKey(measurement)) {
            return 0L;
        }
        return this.memChunkMap.get(measurement).getTVList().rowCount();
    }

    @Override
    public long getMaxTime() {
        long maxTime = Long.MIN_VALUE;
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            maxTime = Math.max(maxTime, memChunk.getMaxTime());
        }
        return maxTime;
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)entry.getKey());
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putInt(this.memChunkMap.size());
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            WALWriteUtils.write(entry.getKey(), buffer);
            IWritableMemChunk memChunk = entry.getValue();
            memChunk.serializeToWAL(buffer);
        }
    }

    public static WritableMemChunkGroup deserialize(DataInputStream stream) throws IOException {
        WritableMemChunkGroup memChunkGroup = new WritableMemChunkGroup();
        int memChunkMapSize = stream.readInt();
        for (int i = 0; i < memChunkMapSize; ++i) {
            String measurement = ReadWriteIOUtils.readString((InputStream)stream);
            WritableMemChunk memChunk = WritableMemChunk.deserialize(stream);
            memChunkGroup.memChunkMap.put(measurement, memChunk);
        }
        return memChunkGroup;
    }
}

