/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.tsfile.file.metadata.IDeviceID;

public class TsFileResourceCandidate {
    public TsFileResource resource;
    public boolean selected;
    public boolean isValidCandidate;
    private Map<IDeviceID, DeviceInfo> deviceInfoMap;
    private boolean hasDetailedDeviceInfo;
    private CompactionScheduleContext compactionScheduleContext;

    public TsFileResourceCandidate(TsFileResource tsFileResource, CompactionScheduleContext context) {
        this.resource = tsFileResource;
        this.selected = false;
        this.isValidCandidate = tsFileResource.getStatus() == TsFileResourceStatus.NORMAL && tsFileResource.getTsFileRepairStatus() == TsFileRepairStatus.NORMAL;
        this.compactionScheduleContext = context;
    }

    public boolean unsealed() {
        return this.resource.getStatus() == TsFileResourceStatus.UNCLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeviceInfos() throws IOException {
        boolean canCacheDeviceInfo;
        boolean bl = canCacheDeviceInfo = this.resource.getStatus() != TsFileResourceStatus.UNCLOSED;
        if (this.deviceInfoMap == null && this.compactionScheduleContext != null) {
            this.deviceInfoMap = this.compactionScheduleContext.getResourceDeviceInfo(this.resource);
            this.hasDetailedDeviceInfo = true;
        }
        if (this.deviceInfoMap != null) {
            return;
        }
        this.deviceInfoMap = new LinkedHashMap<IDeviceID, DeviceInfo>();
        if (this.resource.getTimeIndexType() == 2) {
            this.resource.readLock();
            try {
                if (!this.resource.resourceFileExists()) {
                    this.hasDetailedDeviceInfo = false;
                    return;
                }
                DeviceTimeIndex timeIndex = CompactionUtils.buildDeviceTimeIndex(this.resource);
                for (IDeviceID deviceId : timeIndex.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, timeIndex.getStartTime(deviceId), timeIndex.getEndTime(deviceId)));
                }
            }
            finally {
                this.resource.readUnlock();
            }
        } else {
            for (IDeviceID deviceId : this.resource.getDevices()) {
                this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, this.resource.getStartTime(deviceId), this.resource.getEndTime(deviceId)));
            }
        }
        this.hasDetailedDeviceInfo = true;
        if (this.compactionScheduleContext != null && canCacheDeviceInfo) {
            this.compactionScheduleContext.addResourceDeviceTimeIndex(this.resource, this.deviceInfoMap);
        }
    }

    public void markAsSelected() {
        this.selected = true;
    }

    public List<DeviceInfo> getDeviceInfoList() throws IOException {
        this.prepareDeviceInfos();
        return new ArrayList<DeviceInfo>(this.deviceInfoMap.values());
    }

    public Set<IDeviceID> getDevices() throws IOException {
        this.prepareDeviceInfos();
        return this.deviceInfoMap.keySet();
    }

    public DeviceInfo getDeviceInfoById(IDeviceID deviceId) throws IOException {
        this.prepareDeviceInfos();
        return this.deviceInfoMap.get(deviceId);
    }

    public boolean containsDevice(IDeviceID deviceId) throws IOException {
        this.prepareDeviceInfos();
        return this.deviceInfoMap.containsKey(deviceId);
    }

    public boolean hasDetailedDeviceInfo() throws IOException {
        this.prepareDeviceInfos();
        return this.hasDetailedDeviceInfo;
    }

    public boolean mayHasOverlapWithUnseqFile(DeviceInfo unseqFileDeviceInfo) throws IOException {
        this.prepareDeviceInfos();
        long endTime = this.containsDevice(unseqFileDeviceInfo.deviceId) ? this.getDeviceInfoById((IDeviceID)unseqFileDeviceInfo.deviceId).endTime : this.resource.getFileEndTime();
        return unseqFileDeviceInfo.startTime <= endTime;
    }
}

