/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceForRegionScan;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;

public class VirtualDataRegion
implements IDataRegionForQuery {
    private static final String VIRTUAL_DB_NAME = "root.__virtual";
    private static final QueryDataSource EMPTY_QUERY_DATA_SOURCE = new QueryDataSource(Collections.emptyList(), Collections.emptyList());
    private static final QueryDataSourceForRegionScan EMPTY_REGION_QUERY_DATA_SOURCE = new QueryDataSourceForRegionScan(Collections.emptyList(), Collections.emptyList());

    public static VirtualDataRegion getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public QueryDataSource query(List<PartialPath> pathList, String singleDeviceId, QueryContext context, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        return EMPTY_QUERY_DATA_SOURCE;
    }

    @Override
    public IQueryDataSource queryForDeviceRegionScan(Map<IDeviceID, DeviceContext> devicePathsToContext, QueryContext queryContext, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        return EMPTY_REGION_QUERY_DATA_SOURCE;
    }

    @Override
    public IQueryDataSource queryForSeriesRegionScan(List<PartialPath> pathList, QueryContext queryContext, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        return EMPTY_REGION_QUERY_DATA_SOURCE;
    }

    @Override
    public String getDatabaseName() {
        return VIRTUAL_DB_NAME;
    }

    private static class InstanceHolder {
        private static final VirtualDataRegion INSTANCE = new VirtualDataRegion();

        private InstanceHolder() {
        }
    }
}

