/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class ShowQueriesStatement
extends ShowStatement {
    private WhereCondition whereCondition;
    private OrderByComponent orderByComponent;
    private long rowLimit;
    private long rowOffset;

    public ShowQueriesStatement() {
        this.statementType = StatementType.SHOW_QUERIES;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitShowQueries(this, context);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MAINTAIN.ordinal()), PrivilegeType.MAINTAIN);
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setOrderByComponent(OrderByComponent orderByComponent) {
        this.orderByComponent = orderByComponent;
    }

    public OrderByComponent getOrderByComponent() {
        return this.orderByComponent;
    }

    public List<SortItem> getSortItemList() {
        if (this.orderByComponent == null) {
            return Collections.singletonList(new SortItem("TIME", Ordering.ASC));
        }
        return this.orderByComponent.getSortItemList();
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowOffset(long rowOffset) {
        this.rowOffset = rowOffset;
    }

    public long getRowOffset() {
        return this.rowOffset;
    }
}

