/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class TopKOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TopKOperator.class);
    private final OperatorContext operatorContext;
    private final List<Operator> childrenOperators;
    private int childIndex;
    private final int childBatchStep;
    private final boolean[] canCallNext;
    private final List<TSDataType> dataTypes;
    private final TsBlockBuilder tsBlockBuilder;
    private final MergeSortHeap mergeSortHeap;
    private final Comparator<SortKey> comparator;
    private final int topValue;
    private MergeSortKey[] topKResult;
    private int resultReturnSize = 0;
    private TsBlock tmpResultTsBlock;
    private int tmpResultTsBlockIdx;
    private final boolean childrenDataInOrder;
    public static final int OPERATOR_BATCH_UPPER_BOUND = 100000;

    public TopKOperator(OperatorContext operatorContext, List<Operator> childrenOperators, List<TSDataType> dataTypes, Comparator<SortKey> comparator, int topValue, boolean childrenDataInOrder) {
        this.operatorContext = operatorContext;
        this.childrenOperators = childrenOperators;
        this.dataTypes = dataTypes;
        this.mergeSortHeap = new MergeSortHeap(topValue, comparator.reversed());
        this.comparator = comparator;
        this.tsBlockBuilder = new TsBlockBuilder(topValue, dataTypes);
        this.topValue = topValue;
        this.childrenDataInOrder = childrenDataInOrder;
        this.initResultTsBlock();
        this.childBatchStep = 100000 % topValue == 0 ? 100000 / topValue : 100000 / topValue + 1;
        this.canCallNext = new boolean[childrenOperators.size()];
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = this.childIndex; i < Math.min(this.childIndex + this.childBatchStep, this.childrenOperators.size()); ++i) {
            if (this.getOperator(i) == null) continue;
            ListenableFuture<?> blocked = this.getOperator(i).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.childIndex >= this.childrenOperators.size()) {
            if (this.topKResult == null) {
                return false;
            }
            return this.resultReturnSize < this.topKResult.length;
        }
        return true;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.childIndex >= this.childrenOperators.size() && this.resultReturnSize < this.topKResult.length) {
            return this.getResultFromCachedTopKResult();
        }
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        boolean batchFinished = true;
        int operatorBatchEnd = Math.min(this.childIndex + this.childBatchStep, this.childrenOperators.size());
        for (int i = this.childIndex; i < operatorBatchEnd; ++i) {
            if (this.getOperator(i) == null) continue;
            if (!this.canCallNext[i]) {
                batchFinished = false;
                continue;
            }
            if (!this.getOperator(i).hasNextWithTimer()) {
                this.closeOperator(i);
                continue;
            }
            batchFinished = false;
            TsBlock currentTsBlock = this.getOperator(i).nextWithTimer();
            if (currentTsBlock == null || currentTsBlock.isEmpty()) {
                return null;
            }
            boolean skipCurrentBatch = false;
            for (int vIdx = 0; vIdx < currentTsBlock.getPositionCount(); ++vIdx) {
                if (this.mergeSortHeap.getHeapSize() < this.topValue) {
                    this.updateTsBlockValue(currentTsBlock, vIdx, -1);
                    continue;
                }
                if (this.comparator.compare(new MergeSortKey(currentTsBlock, vIdx), this.mergeSortHeap.peek()) < 0) {
                    MergeSortKey peek = this.mergeSortHeap.poll();
                    this.updateTsBlockValue(currentTsBlock, vIdx, peek.rowIndex);
                    continue;
                }
                if (!this.childrenDataInOrder) continue;
                skipCurrentBatch = true;
                break;
            }
            if (skipCurrentBatch) {
                this.closeOperator(i);
            }
            this.canCallNext[i] = false;
            if (System.nanoTime() - startTime > maxRuntime) break;
        }
        if (batchFinished) {
            this.childIndex += this.childBatchStep;
            if (this.childIndex >= this.childrenOperators.size()) {
                return this.getResultFromCachedTopKResult();
            }
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        for (int i = this.childIndex; i < this.childrenOperators.size(); ++i) {
            Operator operator = this.childrenOperators.get(i);
            if (operator == null) continue;
            operator.close();
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.calculateMaxReturnSize();
        for (Operator operator : this.childrenOperators) {
            maxPeekMemory = Math.max(maxPeekMemory, operator.calculateMaxPeekMemoryWithCounter());
        }
        return Math.max(maxPeekMemory, (long)this.topValue * this.getMemoryUsageOfOneMergeSortKey() * 2L);
    }

    @Override
    public long calculateMaxReturnSize() {
        return TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return (long)(this.topValue - this.resultReturnSize) * this.getMemoryUsageOfOneMergeSortKey();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.childrenOperators.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }

    private void initResultTsBlock() {
        int positionCount = this.topValue;
        Column[] columns = new Column[this.dataTypes.size()];
        block8: for (int i = 0; i < this.dataTypes.size(); ++i) {
            switch (this.dataTypes.get(i)) {
                case BOOLEAN: {
                    columns[i] = new BooleanColumn(positionCount, Optional.of(new boolean[positionCount]), new boolean[positionCount]);
                    continue block8;
                }
                case INT32: {
                    columns[i] = new IntColumn(positionCount, Optional.of(new boolean[positionCount]), new int[positionCount]);
                    continue block8;
                }
                case INT64: {
                    columns[i] = new LongColumn(positionCount, Optional.of(new boolean[positionCount]), new long[positionCount]);
                    continue block8;
                }
                case FLOAT: {
                    columns[i] = new FloatColumn(positionCount, Optional.of(new boolean[positionCount]), new float[positionCount]);
                    continue block8;
                }
                case DOUBLE: {
                    columns[i] = new DoubleColumn(positionCount, Optional.of(new boolean[positionCount]), new double[positionCount]);
                    continue block8;
                }
                case TEXT: {
                    columns[i] = new BinaryColumn(positionCount, Optional.of(new boolean[positionCount]), new Binary[positionCount]);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unknown datatype: " + this.dataTypes.get(i));
                }
            }
        }
        this.tmpResultTsBlock = new TsBlock(positionCount, new TimeColumn(positionCount, new long[positionCount]), columns);
    }

    private TsBlock getResultFromCachedTopKResult() {
        if (this.mergeSortHeap.getHeapSize() > 0) {
            int cnt = this.mergeSortHeap.getHeapSize();
            this.topKResult = new MergeSortKey[cnt];
            while (!this.mergeSortHeap.isEmpty()) {
                this.topKResult[--cnt] = this.mergeSortHeap.poll();
            }
        }
        this.tsBlockBuilder.reset();
        if (this.topKResult == null || this.topKResult.length == 0) {
            return this.tsBlockBuilder.build();
        }
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        for (int i = this.resultReturnSize; i < this.topKResult.length; ++i) {
            MergeSortKey mergeSortKey = this.topKResult[i];
            TsBlock targetBlock = mergeSortKey.tsBlock;
            this.tsBlockBuilder.getTimeColumnBuilder().writeLong(targetBlock.getTimeByIndex(mergeSortKey.rowIndex));
            for (int j = 0; j < valueColumnBuilders.length; ++j) {
                if (targetBlock.getColumn(j).isNull(mergeSortKey.rowIndex)) {
                    valueColumnBuilders[j].appendNull();
                    continue;
                }
                valueColumnBuilders[j].write(targetBlock.getColumn(j), mergeSortKey.rowIndex);
            }
            ++this.resultReturnSize;
            this.tsBlockBuilder.declarePosition();
            if (!this.tsBlockBuilder.isFull()) continue;
            return this.tsBlockBuilder.build();
        }
        return this.tsBlockBuilder.build();
    }

    private long getMemoryUsageOfOneMergeSortKey() {
        long memory = 0L;
        block6: for (TSDataType dataType : this.dataTypes) {
            switch (dataType) {
                case BOOLEAN: {
                    ++memory;
                    continue block6;
                }
                case INT32: 
                case FLOAT: {
                    memory += 4L;
                    continue block6;
                }
                case INT64: 
                case DOUBLE: 
                case VECTOR: {
                    memory += 8L;
                    continue block6;
                }
                case TEXT: {
                    memory += 16L;
                    continue block6;
                }
            }
            throw new UnSupportedDataTypeException("Unknown datatype: " + dataType);
        }
        return memory;
    }

    private void updateTsBlockValue(TsBlock sourceTsBlock, int sourceIndex, int peekIndex) {
        if (peekIndex < 0) {
            this.tmpResultTsBlock.update(this.tmpResultTsBlockIdx, sourceTsBlock, sourceIndex);
            this.mergeSortHeap.push(new MergeSortKey(this.tmpResultTsBlock, this.tmpResultTsBlockIdx++));
            return;
        }
        this.tmpResultTsBlock.update(peekIndex, sourceTsBlock, sourceIndex);
        this.mergeSortHeap.push(new MergeSortKey(this.tmpResultTsBlock, peekIndex));
    }

    private Operator getOperator(int i) {
        return this.childrenOperators.get(i);
    }

    private void closeOperator(int i) throws Exception {
        this.getOperator(i).close();
        this.childrenOperators.set(i, null);
    }
}

