/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.planner.memory.ThreadSafeMemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TimePredicate;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceForRegionScan;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceType;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceContext
extends QueryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceContext.class);
    private static final long END_TIME_INITIAL_VALUE = -1L;
    private final FragmentInstanceId id;
    private final FragmentInstanceStateMachine stateMachine;
    private final MemoryReservationManager memoryReservationManager;
    private IDataRegionForQuery dataRegion;
    private Filter globalTimeFilter;
    private List<PartialPath> sourcePaths;
    private Map<IDeviceID, DeviceContext> devicePathsToContext;
    private IQueryDataSource sharedQueryDataSource;
    private Set<TsFileResource> closedFilePaths;
    private Set<TsFileResource> unClosedFilePaths;
    private boolean mayHaveTmpFile = false;
    private List<Long> timePartitions;
    private QueryDataSourceType queryDataSourceType = QueryDataSourceType.SERIES_SCAN;
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<Long> executionStartTime = new AtomicReference();
    private final AtomicReference<Long> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<Long> executionEndTime = new AtomicReference();
    private CountDownLatch allDriversClosed;
    private SessionInfo sessionInfo;
    private final Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap;
    private DataNodeQueryContext dataNodeQueryContext;
    private TFetchFragmentInstanceStatisticsResp fragmentInstanceStatistics = null;
    private long initQueryDataSourceCost = 0L;
    private final AtomicLong readyQueueTime = new AtomicLong(0L);
    private final AtomicLong blockQueueTime = new AtomicLong(0L);
    private long unclosedSeqFileNum = 0L;
    private long unclosedUnseqFileNum = 0L;
    private long closedSeqFileNum = 0L;
    private long closedUnseqFileNum = 0L;

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter timeFilter) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo, dataRegion, timeFilter);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, TimePredicate globalTimePredicate, Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo, dataRegion, globalTimePredicate, dataNodeQueryContextMap);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContextForCompaction(long queryId) {
        return new FragmentInstanceContext(queryId);
    }

    public void setQueryDataSourceType(QueryDataSourceType queryDataSourceType) {
        this.queryDataSourceType = queryDataSourceType;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, new SessionInfo(1L, "test", ZoneId.systemDefault()));
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, TimePredicate globalTimePredicate, Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataRegion = dataRegion;
        this.globalTimeFilter = globalTimePredicate == null ? null : globalTimePredicate.convertPredicateToTimeFilter();
        this.dataNodeQueryContextMap = dataNodeQueryContextMap;
        this.dataNodeQueryContext = dataNodeQueryContextMap.get(id.getQueryId());
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataNodeQueryContextMap = null;
        this.dataNodeQueryContext = null;
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter globalTimeFilter) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataRegion = dataRegion;
        this.globalTimeFilter = globalTimeFilter;
        this.dataNodeQueryContextMap = null;
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    public void setDataRegion(IDataRegionForQuery dataRegion) {
        this.dataRegion = dataRegion;
    }

    private FragmentInstanceContext(long queryId) {
        this.queryId = queryId;
        this.id = null;
        this.stateMachine = null;
        this.dataNodeQueryContextMap = null;
        this.dataNodeQueryContext = null;
        this.memoryReservationManager = null;
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.lastExecutionStartTime.set(now);
    }

    private void initialize() {
        this.stateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    private void updateStatsIfDone(FragmentInstanceState newState) {
        if (newState.isDone()) {
            long now = System.currentTimeMillis();
            this.executionStartTime.compareAndSet(null, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.executionEndTime.compareAndSet(-1L, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
            this.releaseDataNodeQueryContext();
            this.sourcePaths = null;
        }
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public void failed(Throwable cause) {
        this.stateMachine.failed(cause);
    }

    public String getFailedCause() {
        return this.stateMachine.getFailureCauses().stream().findFirst().map(Throwable::getMessage).orElse("");
    }

    public List<FragmentInstanceFailureInfo> getFailureInfoList() {
        return this.stateMachine.getFailureCauses().stream().map(FragmentInstanceFailureInfo::toFragmentInstanceFailureInfo).collect(Collectors.toList());
    }

    public Optional<TSStatus> getErrorCode() {
        return this.stateMachine.getFailureCauses().stream().filter(IoTDBException.class::isInstance).findFirst().flatMap(t -> {
            TSStatus status = new TSStatus(((IoTDBException)((Object)t)).getErrorCode());
            status.setMessage(t.getMessage());
            return Optional.of(status);
        });
    }

    public void finished() {
        this.stateMachine.finished();
    }

    public void transitionToFlushing() {
        this.stateMachine.transitionToFlushing();
    }

    public void cancel() {
        this.stateMachine.cancel();
    }

    public void abort() {
        this.stateMachine.abort();
    }

    public long getEndTime() {
        return this.executionEndTime.get();
    }

    public boolean isEndTimeUpdate() {
        return this.executionEndTime.get() != -1L;
    }

    @Override
    public long getStartTime() {
        return this.executionStartTime.get();
    }

    public DataNodeQueryContext getDataNodeQueryContext() {
        return this.dataNodeQueryContext;
    }

    public void setDataNodeQueryContext(DataNodeQueryContext dataNodeQueryContext) {
        this.dataNodeQueryContext = dataNodeQueryContext;
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return this.getErrorCode().map(s -> new FragmentInstanceInfo(this.stateMachine.getState(), this.getEndTime(), this.getFailedCause(), this.getFailureInfoList(), (TSStatus)s)).orElseGet(() -> new FragmentInstanceInfo(this.stateMachine.getState(), this.getEndTime(), this.getFailedCause(), this.getFailureInfoList()));
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.stateMachine.getFailureCauses().peek());
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public IDataRegionForQuery getDataRegion() {
        return this.dataRegion;
    }

    public void setSourcePaths(List<PartialPath> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setDevicePathsToContext(Map<IDeviceID, DeviceContext> devicePathsToContext) {
        this.devicePathsToContext = devicePathsToContext;
    }

    public MemoryReservationManager getMemoryReservationContext() {
        return this.memoryReservationManager;
    }

    public void releaseMemoryReservationManager() {
        this.memoryReservationManager.releaseAllReservedMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initQueryDataSource(List<PartialPath> sourcePaths) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (sourcePaths == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            HashSet<String> selectedDeviceIdSet = new HashSet<String>();
            for (PartialPath path : sourcePaths) {
                pathList.add(path);
                selectedDeviceIdSet.add(path.getDevice());
            }
            this.sharedQueryDataSource = this.dataRegion.query(pathList, selectedDeviceIdSet.size() == 1 ? (String)selectedDeviceIdSet.iterator().next() : null, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForQuery((QueryDataSource)this.sharedQueryDataSource);
                ((QueryDataSource)this.sharedQueryDataSource).setSingleDevice(selectedDeviceIdSet.size() == 1);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRegionScanQueryDataSource(Map<IDeviceID, DeviceContext> devicePathsToContext) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (devicePathsToContext == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            this.sharedQueryDataSource = this.dataRegion.queryForDeviceRegionScan(devicePathsToContext, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForRegionQuery((QueryDataSourceForRegionScan)this.sharedQueryDataSource);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRegionScanQueryDataSource(List<PartialPath> pathList) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (pathList == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            this.sharedQueryDataSource = this.dataRegion.queryForSeriesRegionScan(pathList, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForRegionQuery((QueryDataSourceForRegionScan)this.sharedQueryDataSource);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    public synchronized IQueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        if (this.sharedQueryDataSource == null) {
            switch (this.queryDataSourceType) {
                case SERIES_SCAN: {
                    this.initQueryDataSource(this.sourcePaths);
                    this.sourcePaths = null;
                    break;
                }
                case DEVICE_REGION_SCAN: {
                    this.initRegionScanQueryDataSource(this.devicePathsToContext);
                    this.devicePathsToContext = null;
                    break;
                }
                case TIME_SERIES_REGION_SCAN: {
                    this.initRegionScanQueryDataSource(this.sourcePaths);
                    this.sourcePaths = null;
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported query data source type: " + (Object)((Object)this.queryDataSourceType));
                }
            }
        }
        return this.sharedQueryDataSource;
    }

    private boolean processTsFileResource(TsFileResource tsFileResource, boolean isClosed) {
        this.addFilePathToMap(tsFileResource, isClosed);
        if (tsFileResource.isDeleted()) {
            Set<TsFileResource> pathSet;
            Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
            if (pathSet.remove(tsFileResource)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            return true;
        }
        return false;
    }

    private void addUsedFilesForQuery(QueryDataSource dataSource) {
        dataSource.getSeqResources().removeIf(tsFileResource -> this.processTsFileResource((TsFileResource)tsFileResource, tsFileResource.isClosed()));
        this.unclosedSeqFileNum = this.unClosedFilePaths.size();
        this.closedSeqFileNum = this.closedFilePaths.size();
        dataSource.getUnseqResources().removeIf(tsFileResource -> this.processTsFileResource((TsFileResource)tsFileResource, tsFileResource.isClosed()));
        this.unclosedUnseqFileNum = (long)this.unClosedFilePaths.size() - this.unclosedSeqFileNum;
        this.closedUnseqFileNum = (long)this.closedFilePaths.size() - this.closedSeqFileNum;
    }

    private void addUsedFilesForRegionQuery(QueryDataSourceForRegionScan dataSource) {
        dataSource.getSeqFileScanHandles().removeIf(fileScanHandle -> this.processTsFileResource(fileScanHandle.getTsResource(), fileScanHandle.isClosed()));
        this.unclosedSeqFileNum = this.unClosedFilePaths.size();
        this.closedSeqFileNum = this.closedFilePaths.size();
        dataSource.getUnseqFileScanHandles().removeIf(fileScanHandle -> this.processTsFileResource(fileScanHandle.getTsResource(), fileScanHandle.isClosed()));
        this.unclosedUnseqFileNum = (long)this.unClosedFilePaths.size() - this.unclosedSeqFileNum;
        this.closedUnseqFileNum = (long)this.closedFilePaths.size() - this.closedSeqFileNum;
    }

    private void addFilePathToMap(TsFileResource tsFile, boolean isClosed) {
        Set<TsFileResource> pathSet;
        Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
        if (!pathSet.contains(tsFile)) {
            pathSet.add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }

    public void initializeNumOfDrivers(int numOfDrivers) {
        this.allDriversClosed = new CountDownLatch(numOfDrivers);
    }

    public void decrementNumOfUnClosedDriver() {
        this.allDriversClosed.countDown();
    }

    public void releaseResourceWhenAllDriversAreClosed() {
        while (true) {
            try {
                this.allDriversClosed.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupted when await on allDriversClosed, FragmentInstance Id is {}", (Object)this.getId());
                continue;
            }
            break;
        }
        this.releaseResource();
    }

    public synchronized void releaseResource() {
        if (this.closedFilePaths != null) {
            for (TsFileResource tsFile : this.closedFilePaths) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
            }
            this.closedFilePaths = null;
        }
        if (this.unClosedFilePaths != null) {
            for (TsFileResource tsFile : this.unClosedFilePaths) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
            }
            this.unClosedFilePaths = null;
        }
        this.dataRegion = null;
        this.globalTimeFilter = null;
        this.sharedQueryDataSource = null;
        long durationTime = System.currentTimeMillis() - this.executionStartTime.get();
        QueryRelatedResourceMetricSet.getInstance().updateFragmentInstanceTime(durationTime);
        SeriesScanCostMetricSet.getInstance().recordNonAlignedTimeSeriesMetadataCount(this.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqCount().get());
        SeriesScanCostMetricSet.getInstance().recordNonAlignedTimeSeriesMetadataTime(this.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqTime().get());
        SeriesScanCostMetricSet.getInstance().recordAlignedTimeSeriesMetadataCount(this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqCount().get());
        SeriesScanCostMetricSet.getInstance().recordAlignedTimeSeriesMetadataTime(this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqTime().get());
        SeriesScanCostMetricSet.getInstance().recordConstructChunkReadersCount(this.getQueryStatistics().getConstructAlignedChunkReadersMemCount().get(), this.getQueryStatistics().getConstructAlignedChunkReadersDiskCount().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersMemCount().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersDiskCount().get());
        SeriesScanCostMetricSet.getInstance().recordConstructChunkReadersTime(this.getQueryStatistics().getConstructAlignedChunkReadersMemTime().get(), this.getQueryStatistics().getConstructAlignedChunkReadersDiskTime().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersMemTime().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersDiskTime().get());
        SeriesScanCostMetricSet.getInstance().recordPageReadersDecompressCount(this.getQueryStatistics().getPageReadersDecodeAlignedMemCount().get(), this.getQueryStatistics().getPageReadersDecodeAlignedDiskCount().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedMemCount().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedDiskCount().get());
        SeriesScanCostMetricSet.getInstance().recordPageReadersDecompressTime(this.getQueryStatistics().getPageReadersDecodeAlignedMemTime().get(), this.getQueryStatistics().getPageReadersDecodeAlignedDiskTime().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedMemTime().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedDiskTime().get());
        SeriesScanCostMetricSet.getInstance().recordTimeSeriesMetadataModification(this.getQueryStatistics().getAlignedTimeSeriesMetadataModificationCount().get(), this.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationCount().get(), this.getQueryStatistics().getAlignedTimeSeriesMetadataModificationTime().get(), this.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationTime().get());
        SeriesScanCostMetricSet.getInstance().updatePageReaderMemoryUsage(this.getQueryStatistics().getPageReaderMaxUsedMemorySize().get());
    }

    private synchronized void releaseDataNodeQueryContext() {
        if (this.dataNodeQueryContextMap == null) {
            return;
        }
        if (this.dataNodeQueryContext.decreaseDataNodeFINum() == 0) {
            this.dataNodeQueryContext = null;
            this.dataNodeQueryContextMap.remove(this.id.getQueryId());
        }
    }

    public void setMayHaveTmpFile(boolean mayHaveTmpFile) {
        this.mayHaveTmpFile = mayHaveTmpFile;
    }

    public boolean mayHaveTmpFile() {
        return this.mayHaveTmpFile;
    }

    public Optional<List<Long>> getTimePartitions() {
        return Optional.ofNullable(this.timePartitions);
    }

    public void setTimePartitions(List<Long> timePartitions) {
        this.timePartitions = timePartitions;
    }

    public void setFragmentInstanceStatistics(TFetchFragmentInstanceStatisticsResp statistics) {
        this.fragmentInstanceStatistics = statistics;
    }

    public TFetchFragmentInstanceStatisticsResp getFragmentInstanceStatistics() {
        return this.fragmentInstanceStatistics;
    }

    public void setInitQueryDataSourceCost(long initQueryDataSourceCost) {
        this.initQueryDataSourceCost = initQueryDataSourceCost;
    }

    public long getInitQueryDataSourceCost() {
        return this.initQueryDataSourceCost;
    }

    public void addReadyQueuedTime(long time) {
        this.readyQueueTime.addAndGet(time);
    }

    public void addBlockQueuedTime(long time) {
        this.blockQueueTime.addAndGet(time);
    }

    public long getReadyQueueTime() {
        return this.readyQueueTime.get();
    }

    public long getBlockQueueTime() {
        return this.blockQueueTime.get();
    }

    public long getClosedSeqFileNum() {
        return this.closedSeqFileNum;
    }

    public long getUnclosedUnseqFileNum() {
        return this.unclosedUnseqFileNum;
    }

    public long getClosedUnseqFileNum() {
        return this.closedUnseqFileNum;
    }

    public long getUnclosedSeqFileNum() {
        return this.unclosedSeqFileNum;
    }
}

