/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.ResultNodeContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.planner.memory.NotThreadSafeMemoryReservationManager;
import org.apache.iotdb.db.queryengine.statistics.QueryPlanStatistics;
import org.apache.tsfile.read.filter.basic.Filter;

public class MPPQueryContext {
    private String sql;
    private final QueryId queryId;
    private long localQueryId;
    private SessionInfo session;
    private QueryType queryType = QueryType.READ;
    private long timeOut;
    private long startTime;
    private TEndPoint localDataBlockEndpoint;
    private TEndPoint localInternalEndpoint;
    private ResultNodeContext resultNodeContext;
    private TRegionReplicaSet mainFragmentLocatedRegion;
    private final List<TEndPoint> endPointBlackList;
    private final TypeProvider typeProvider = new TypeProvider();
    private Filter globalTimeFilter;
    private final Set<SchemaLockType> acquiredLocks = new HashSet<SchemaLockType>();
    private boolean isExplainAnalyze = false;
    QueryPlanStatistics queryPlanStatistics = null;
    private final MemoryReservationManager memoryReservationManager;

    public MPPQueryContext(QueryId queryId) {
        this.queryId = queryId;
        this.endPointBlackList = new LinkedList<TEndPoint>();
        this.memoryReservationManager = new NotThreadSafeMemoryReservationManager(queryId, this.getClass().getName());
    }

    public MPPQueryContext(String sql, QueryId queryId, SessionInfo session, TEndPoint localDataBlockEndpoint, TEndPoint localInternalEndpoint) {
        this(queryId);
        this.sql = sql;
        this.session = session;
        this.localDataBlockEndpoint = localDataBlockEndpoint;
        this.localInternalEndpoint = localInternalEndpoint;
        this.initResultNodeContext();
    }

    public MPPQueryContext(String sql, QueryId queryId, long localQueryId, SessionInfo session, TEndPoint localDataBlockEndpoint, TEndPoint localInternalEndpoint) {
        this(queryId);
        this.sql = sql;
        this.session = session;
        this.localQueryId = localQueryId;
        this.localDataBlockEndpoint = localDataBlockEndpoint;
        this.localInternalEndpoint = localInternalEndpoint;
        this.initResultNodeContext();
    }

    public void prepareForRetry() {
        this.initResultNodeContext();
        this.releaseAllMemoryReservedForFrontEnd();
    }

    private void initResultNodeContext() {
        this.resultNodeContext = new ResultNodeContext(this.queryId);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public long getLocalQueryId() {
        return this.localQueryId;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public ResultNodeContext getResultNodeContext() {
        return this.resultNodeContext;
    }

    public TEndPoint getLocalDataBlockEndpoint() {
        return this.localDataBlockEndpoint;
    }

    public TEndPoint getLocalInternalEndpoint() {
        return this.localInternalEndpoint;
    }

    public SessionInfo getSession() {
        return this.session;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void addFailedEndPoint(TEndPoint endPoint) {
        this.endPointBlackList.add(endPoint);
    }

    public List<TEndPoint> getEndPointBlackList() {
        return this.endPointBlackList;
    }

    public TRegionReplicaSet getMainFragmentLocatedRegion() {
        return this.mainFragmentLocatedRegion;
    }

    public void setMainFragmentLocatedRegion(TRegionReplicaSet region) {
        this.mainFragmentLocatedRegion = region;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public String getSql() {
        return this.sql;
    }

    public Set<SchemaLockType> getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public boolean addAcquiredLock(SchemaLockType lockType) {
        return this.acquiredLocks.add(lockType);
    }

    public void generateGlobalTimeFilter(Analysis analysis) {
        this.globalTimeFilter = PredicateUtils.convertPredicateToTimeFilter(analysis.getGlobalTimePredicate());
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null;
    }

    public ZoneId getZoneId() {
        return this.session.getZoneId();
    }

    public void setExplainAnalyze(boolean explainAnalyze) {
        this.isExplainAnalyze = explainAnalyze;
    }

    public boolean isExplainAnalyze() {
        return this.isExplainAnalyze;
    }

    public long getAnalyzeCost() {
        return this.queryPlanStatistics.getAnalyzeCost();
    }

    public long getDistributionPlanCost() {
        return this.queryPlanStatistics.getDistributionPlanCost();
    }

    public long getFetchPartitionCost() {
        return this.queryPlanStatistics.getFetchPartitionCost();
    }

    public long getFetchSchemaCost() {
        return this.queryPlanStatistics.getFetchSchemaCost();
    }

    public long getLogicalPlanCost() {
        return this.queryPlanStatistics.getLogicalPlanCost();
    }

    public long getLogicalOptimizationCost() {
        return this.queryPlanStatistics.getLogicalOptimizationCost();
    }

    public void recordDispatchCost(long dispatchCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.recordDispatchCost(dispatchCost);
    }

    public long getDispatchCost() {
        return this.queryPlanStatistics.getDispatchCost();
    }

    public void setAnalyzeCost(long analyzeCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setAnalyzeCost(analyzeCost);
    }

    public void setDistributionPlanCost(long distributionPlanCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setDistributionPlanCost(distributionPlanCost);
    }

    public void setFetchPartitionCost(long fetchPartitionCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setFetchPartitionCost(fetchPartitionCost);
    }

    public void setFetchSchemaCost(long fetchSchemaCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setFetchSchemaCost(fetchSchemaCost);
    }

    public void setLogicalPlanCost(long logicalPlanCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setLogicalPlanCost(logicalPlanCost);
    }

    public void setLogicalOptimizationCost(long logicalOptimizeCost) {
        if (this.queryPlanStatistics == null) {
            this.queryPlanStatistics = new QueryPlanStatistics();
        }
        this.queryPlanStatistics.setLogicalOptimizationCost(logicalOptimizeCost);
    }

    public void reserveMemoryForFrontEnd(long bytes) {
        this.memoryReservationManager.reserveMemoryCumulatively(bytes);
    }

    public void reserveMemoryForFrontEndImmediately() {
        this.memoryReservationManager.reserveMemoryImmediately();
    }

    public void releaseAllMemoryReservedForFrontEnd() {
        this.memoryReservationManager.releaseAllReservedMemory();
    }

    public void releaseMemoryReservedForFrontEnd(long bytes) {
        this.memoryReservationManager.releaseMemoryCumulatively(bytes);
    }
}

