/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.file.SystemPropertiesHandler;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.DataNodeSystemPropertiesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeInfo {
    private static final Logger logger = LoggerFactory.getLogger(ConfigNodeInfo.class);
    private static final String CONFIG_NODE_LIST = "config_node_list";
    private final ReentrantReadWriteLock configNodeInfoReadWriteLock;
    private final Set<TEndPoint> onlineConfigNodes;
    public static final ConfigRegionId CONFIG_REGION_ID = new ConfigRegionId(0);
    SystemPropertiesHandler systemPropertiesHandler = DataNodeSystemPropertiesHandler.getInstance();

    private ConfigNodeInfo() {
        this.configNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.onlineConfigNodes = new HashSet<TEndPoint>();
    }

    public static void reinitializeStatics() {
        ConfigNodeInfoHolder.INSTANCE = new ConfigNodeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfigNodeList(List<TEndPoint> latestConfigNodes) {
        long startTime = System.currentTimeMillis();
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            if (this.onlineConfigNodes.size() == latestConfigNodes.size() && this.onlineConfigNodes.containsAll(latestConfigNodes)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            this.onlineConfigNodes.clear();
            this.onlineConfigNodes.addAll(latestConfigNodes);
            this.storeConfigNodeList();
            long endTime = System.currentTimeMillis();
            logger.info("Update ConfigNode Successfully: {}, which takes {} ms.", this.onlineConfigNodes, (Object)(endTime - startTime));
        }
        catch (IOException e) {
            logger.error("Update ConfigNode failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return true;
    }

    public void storeConfigNodeList() throws IOException {
        if (!this.systemPropertiesHandler.fileExist()) {
            logger.info("System properties file not exist, not necessary to store ConfigNode list");
            return;
        }
        this.systemPropertiesHandler.put(new Object[]{CONFIG_NODE_LIST, NodeUrlUtils.convertTEndPointUrls(new ArrayList<TEndPoint>(this.onlineConfigNodes))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigNodeList() {
        long startTime = System.currentTimeMillis();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            Properties properties = this.systemPropertiesHandler.read();
            if (properties.containsKey(CONFIG_NODE_LIST)) {
                this.onlineConfigNodes.clear();
                this.onlineConfigNodes.addAll(NodeUrlUtils.parseTEndPointUrls((String)properties.getProperty(CONFIG_NODE_LIST)));
            }
            long endTime = System.currentTimeMillis();
            logger.info("Load ConfigNode successfully: {}, which takes {} ms.", this.onlineConfigNodes, (Object)(endTime - startTime));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BadNodeUrlException e) {
            logger.error("Cannot parse config node list in system.properties");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    public List<TEndPoint> getLatestConfigNodes() {
        ArrayList<TEndPoint> result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TEndPoint>(this.onlineConfigNodes);
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public static ConfigNodeInfo getInstance() {
        return ConfigNodeInfoHolder.INSTANCE;
    }

    private static class ConfigNodeInfoHolder {
        private static ConfigNodeInfo INSTANCE = new ConfigNodeInfo();

        private ConfigNodeInfoHolder() {
        }
    }
}

