/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.wal;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeWALResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeWALResourceManager.class);
    protected final Map<Long, PipeWALResource> memtableIdToPipeWALResourceMap = new ConcurrentHashMap<Long, PipeWALResource>();
    private static final int SEGMENT_LOCK_COUNT = 32;
    private final ReentrantLock[] memTableIdSegmentLocks = new ReentrantLock[32];

    protected PipeWALResourceManager() {
        for (int i = 0; i < 32; ++i) {
            this.memTableIdSegmentLocks[i] = new ReentrantLock();
        }
        PipeDataNodeAgent.runtime().registerPeriodicalJob("PipeWALResourceManager#ttlCheck()", this::ttlCheck, Math.max(20L, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ttlCheck() {
        Iterator<Map.Entry<Long, PipeWALResource>> iterator = this.memtableIdToPipeWALResourceMap.entrySet().iterator();
        Optional logger = PipeDataNodeResourceManager.log().schedule(PipeWALResourceManager.class, PipeConfig.getInstance().getPipeWalPinMaxLogNumPerRound(), PipeConfig.getInstance().getPipeWalPinMaxLogIntervalRounds(), this.memtableIdToPipeWALResourceMap.size());
        try {
            while (iterator.hasNext()) {
                Map.Entry<Long, PipeWALResource> entry = iterator.next();
                ReentrantLock lock = this.memTableIdSegmentLocks[(int)(entry.getKey() % 32L)];
                lock.lock();
                try {
                    if (entry.getValue().invalidateIfPossible()) {
                        iterator.remove();
                        continue;
                    }
                    logger.ifPresent(l -> l.info("WAL (memtableId {}) is still referenced {} times", entry.getKey(), (Object)((PipeWALResource)entry.getValue()).getReferenceCount()));
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (ConcurrentModificationException e) {
            LOGGER.error("Concurrent modification issues happened, skipping the WAL in this round of ttl check", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pin(WALEntryHandler walEntryHandler) throws IOException {
        long memTableId = walEntryHandler.getMemTableId();
        ReentrantLock lock = this.memTableIdSegmentLocks[(int)(memTableId % 32L)];
        lock.lock();
        try {
            this.pinInternal(memTableId, walEntryHandler);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void pinInternal(long var1, WALEntryHandler var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpin(WALEntryHandler walEntryHandler) throws IOException {
        long memTableId = walEntryHandler.getMemTableId();
        ReentrantLock lock = this.memTableIdSegmentLocks[(int)(memTableId % 32L)];
        lock.lock();
        try {
            this.unpinInternal(memTableId, walEntryHandler);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void unpinInternal(long var1, WALEntryHandler var3) throws IOException;

    public int getPinnedWalCount() {
        return Objects.nonNull(this.memtableIdToPipeWALResourceMap) ? this.memtableIdToPipeWALResourceMap.size() : 0;
    }
}

