/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.IoTProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.TimeWindowStateProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertNodeMemoryEstimator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertNodeMemoryEstimator.class);
    private static final String INSERT_TABLET_NODE = "InsertTabletNode";
    private static final String INSERT_ROW_NODE = "InsertRowNode";
    private static final String INSERT_ROWS_NODE = "InsertRowsNode";
    private static final String INSERT_ROWS_OF_ONE_DEVICE_NODE = "InsertRowsOfOneDeviceNode";
    private static final String INSERT_MULTI_TABLETS_NODE = "InsertMultiTabletsNode";
    private static final String RELATIONAL_INSERT_ROW_NODE = "RelationalInsertRowNode";
    private static final long NUM_BYTES_OBJECT_REF = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    private static final long NUM_BYTES_OBJECT_HEADER = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
    private static final long NUM_BYTES_ARRAY_HEADER = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private static final long REENTRANT_READ_WRITE_LOCK_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReentrantReadWriteLock.class);
    private static final long TS_ENCODING_PLAIN_BUILDER_SIZE = RamUsageEstimator.shallowSizeOf((Object)TSEncodingBuilder.getEncodingBuilder((TSEncoding)TSEncoding.PLAIN));
    private static final long INSERT_TABLET_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertTabletNode.class);
    private static final long INSERT_ROW_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowNode.class);
    private static final long INSERT_ROWS_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowsNode.class);
    private static final long INSERT_ROWS_OF_ONE_DEVICE_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowsOfOneDeviceNode.class);
    private static final long INSERT_MULTI_TABLETS_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertMultiTabletsNode.class);
    private static final long PARTIAL_PATH_SIZE = RamUsageEstimator.shallowSizeOfInstance(PartialPath.class);
    private static final long MEASUREMENT_SCHEMA_SIZE = RamUsageEstimator.shallowSizeOfInstance(MeasurementSchema.class);
    private static final long PLAIN_DEVICE_ID_SIZE = RamUsageEstimator.shallowSizeOfInstance(PlainDeviceID.class);
    private static final long T_REGION_REPLICA_SET_SIZE = RamUsageEstimator.shallowSizeOfInstance(TRegionReplicaSet.class);
    private static final long T_DATA_NODE_LOCATION_SIZE = RamUsageEstimator.shallowSizeOfInstance(TDataNodeLocation.class);
    private static final long TS_STATUS_SIZE = RamUsageEstimator.shallowSizeOfInstance(TSStatus.class);
    private static final long T_END_POINT_SIZE = RamUsageEstimator.shallowSizeOfInstance(TEndPoint.class);
    private static final long T_CONSENSUS_GROUP_ID_SIZE = RamUsageEstimator.shallowSizeOfInstance(TConsensusGroupId.class);
    private static final long HYBRID_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(HybridProgressIndex.class);
    private static final long IOT_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(IoTProgressIndex.class);
    private static final long META_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(MetaProgressIndex.class);
    private static final long RECOVER_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(RecoverProgressIndex.class);
    private static final long SIMPLE_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(SimpleProgressIndex.class);
    private static final long STATE_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(StateProgressIndex.class);
    private static final long TIME_WINDOW_STATE_PROGRESS_INDEX_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeWindowStateProgressIndex.class);
    private static final long BIT_MAP_SIZE = RamUsageEstimator.shallowSizeOfInstance(BitMap.class);
    private static final long SIZE_OF_LONG = RamUsageEstimator.alignObjectSize((long)(8L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_INT = RamUsageEstimator.alignObjectSize((long)(4L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_DOUBLE = RamUsageEstimator.alignObjectSize((long)(8L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_FLOAT = RamUsageEstimator.alignObjectSize((long)(4L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_BOOLEAN = RamUsageEstimator.alignObjectSize((long)(1L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_SHORT = RamUsageEstimator.alignObjectSize((long)(2L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_STRING = RamUsageEstimator.shallowSizeOfInstance(String.class);
    private static final double INSERT_ROW_NODE_EXPANSION_FACTOR = 1.3;

    public static long sizeOf(InsertNode insertNode) {
        try {
            String className;
            switch (className = insertNode.getClass().getSimpleName()) {
                case "InsertTabletNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertTabletNode((InsertTabletNode)insertNode);
                }
                case "InsertRowNode": {
                    return (long)((double)InsertNodeMemoryEstimator.sizeOfInsertRowNode((InsertRowNode)insertNode) * 1.3);
                }
                case "InsertRowsNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertRowsNode((InsertRowsNode)insertNode);
                }
                case "InsertRowsOfOneDeviceNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertRowsOfOneDeviceNode((InsertRowsOfOneDeviceNode)insertNode);
                }
                case "InsertMultiTabletsNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertMultiTabletsNode((InsertMultiTabletsNode)insertNode);
                }
            }
            return 0L;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to estimate size for InsertNode: {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    private static long calculateFullInsertNodeSize(InsertNode node) {
        long size = 0L;
        size += InsertNodeMemoryEstimator.sizeOfPartialPath(node.getDevicePath());
        size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(node.getMeasurementSchemas());
        size += InsertNodeMemoryEstimator.sizeOfMeasurement(node.getMeasurements());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        if (node.isDeviceIDExists()) {
            size += InsertNodeMemoryEstimator.sizeOfIDeviceID(node.getDeviceID());
        }
        size += InsertNodeMemoryEstimator.sizeOfTRegionReplicaSet(node.getRegionReplicaSet());
        return size += InsertNodeMemoryEstimator.sizeOfProgressIndex(node.getProgressIndex());
    }

    private static long calculateInsertNodeSizeExcludingSchemas(InsertNode node) {
        long size = 2L * RamUsageEstimator.shallowSizeOf((Object[])node.getMeasurementSchemas());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        if (node.isDeviceIDExists()) {
            size += InsertNodeMemoryEstimator.sizeOfIDeviceID(node.getDeviceID());
        }
        size += InsertNodeMemoryEstimator.sizeOfTRegionReplicaSet(node.getRegionReplicaSet());
        return size += InsertNodeMemoryEstimator.sizeOfProgressIndex(node.getProgressIndex());
    }

    private static long sizeOfInsertTabletNode(InsertTabletNode node) {
        long size = INSERT_TABLET_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        size += InsertNodeMemoryEstimator.sizeOfTimes(node.getTimes());
        size += InsertNodeMemoryEstimator.sizeOfBitMapArray(node.getBitMaps());
        size += InsertNodeMemoryEstimator.sizeOfColumns(node.getColumns(), node.getMeasurementSchemas());
        List<Integer> range = node.getRange();
        if (range != null) {
            size += NUM_BYTES_OBJECT_HEADER + SIZE_OF_INT * (long)range.size();
        }
        return size;
    }

    private static long calculateInsertTabletNodeSizeExcludingSchemas(InsertTabletNode node) {
        long size = INSERT_TABLET_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateInsertNodeSizeExcludingSchemas(node);
        size += InsertNodeMemoryEstimator.sizeOfTimes(node.getTimes());
        size += InsertNodeMemoryEstimator.sizeOfBitMapArray(node.getBitMaps());
        size += InsertNodeMemoryEstimator.sizeOfColumns(node.getColumns(), node.getMeasurementSchemas());
        List<Integer> range = node.getRange();
        if (range != null) {
            size += NUM_BYTES_OBJECT_HEADER + SIZE_OF_INT * (long)range.size();
        }
        return size;
    }

    private static long sizeOfInsertRowNode(InsertRowNode node) {
        long size = INSERT_ROW_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        return size += InsertNodeMemoryEstimator.sizeOfValues(node.getValues(), node.getMeasurementSchemas());
    }

    private static long calculateInsertRowNodeExcludingSchemas(InsertRowNode node) {
        long size = INSERT_ROW_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateInsertNodeSizeExcludingSchemas(node);
        return size += InsertNodeMemoryEstimator.sizeOfValues(node.getValues(), node.getMeasurementSchemas());
    }

    private static long sizeOfInsertRowsNode(InsertRowsNode node) {
        long size = INSERT_ROWS_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        List<InsertRowNode> rows = node.getInsertRowNodeList();
        List<Integer> indexList = node.getInsertRowNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertRowNodeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getDevicePath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        return size;
    }

    private static long sizeOfInsertRowsOfOneDeviceNode(InsertRowsOfOneDeviceNode node) {
        long size = INSERT_ROWS_OF_ONE_DEVICE_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        List<InsertRowNode> rows = node.getInsertRowNodeList();
        List<Integer> indexList = node.getInsertRowNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertRowNodeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getDevicePath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        size += NUM_BYTES_OBJECT_HEADER;
        for (Map.Entry<Integer, TSStatus> entry : node.getResults().entrySet()) {
            size += 4L + InsertNodeMemoryEstimator.sizeOfTSStatus(entry.getValue()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
        }
        return size;
    }

    private static long sizeOfInsertMultiTabletsNode(InsertMultiTabletsNode node) {
        long size = INSERT_MULTI_TABLETS_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        List<InsertTabletNode> rows = node.getInsertTabletNodeList();
        List<Integer> indexList = node.getParentInsertTabletNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertTabletNodeSizeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getDevicePath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        if (node.getResults() != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry<Integer, TSStatus> entry : node.getResults().entrySet()) {
                size += 4L + InsertNodeMemoryEstimator.sizeOfTSStatus(entry.getValue()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
        }
        return size;
    }

    private static long sizeOfPartialPath(PartialPath partialPath) {
        if (partialPath == null) {
            return 0L;
        }
        long size = PARTIAL_PATH_SIZE;
        String[] nodes = partialPath.getNodes();
        if (nodes != null) {
            size += InsertNodeMemoryEstimator.sizeOfStringArray(nodes) * 2L;
            size += (long)(".".length() * (nodes.length - 1)) + NUM_BYTES_OBJECT_HEADER;
        }
        return size;
    }

    private static long sizeOfMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        if (measurementSchemas == null) {
            return 0L;
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)measurementSchemas.length));
        for (MeasurementSchema measurementSchema : measurementSchemas) {
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchema(measurementSchema);
        }
        return size;
    }

    private static long sizeOfMeasurementSchema(MeasurementSchema measurementSchema) {
        if (measurementSchema == null) {
            return 0L;
        }
        long size = MEASUREMENT_SCHEMA_SIZE;
        size += InsertNodeMemoryEstimator.sizeOfString(measurementSchema.getMeasurementId());
        Map props = measurementSchema.getProps();
        if (props != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry entry : props.entrySet()) {
                size += InsertNodeMemoryEstimator.sizeOfString((String)entry.getKey()) + InsertNodeMemoryEstimator.sizeOfString((String)entry.getValue()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
        }
        return size += TS_ENCODING_PLAIN_BUILDER_SIZE;
    }

    private static long sizeOfMeasurement(String[] measurement) {
        if (measurement == null) {
            return 0L;
        }
        return InsertNodeMemoryEstimator.sizeOfStringArray(measurement);
    }

    private static long sizeOfIDeviceID(IDeviceID deviceID) {
        if (deviceID == null) {
            return 0L;
        }
        return InsertNodeMemoryEstimator.sizeOfPlainDeviceID((PlainDeviceID)deviceID);
    }

    private static long sizeOfPlainDeviceID(PlainDeviceID deviceID) {
        long size = PLAIN_DEVICE_ID_SIZE;
        String id = deviceID.toString();
        if (id != null) {
            size += InsertNodeMemoryEstimator.sizeOfString(id) * 2L;
        }
        return size;
    }

    private static long sizeOfTRegionReplicaSet(TRegionReplicaSet tRegionReplicaSet) {
        if (tRegionReplicaSet == null) {
            return 0L;
        }
        long size = T_REGION_REPLICA_SET_SIZE;
        if (tRegionReplicaSet.isSetRegionId()) {
            size += InsertNodeMemoryEstimator.sizeOfTConsensusGroupId();
        }
        if (tRegionReplicaSet.isSetDataNodeLocations()) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (TDataNodeLocation tDataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                size += InsertNodeMemoryEstimator.sizeOfTDataNodeLocation(tDataNodeLocation);
            }
        }
        return size;
    }

    private static long sizeOfTConsensusGroupId() {
        return T_CONSENSUS_GROUP_ID_SIZE;
    }

    private static long sizeOfTDataNodeLocation(TDataNodeLocation tDataNodeLocation) {
        if (tDataNodeLocation == null) {
            return 0L;
        }
        long size = T_DATA_NODE_LOCATION_SIZE;
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getClientRpcEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getInternalEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getMPPDataExchangeEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getDataRegionConsensusEndPoint());
        return size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getSchemaRegionConsensusEndPoint());
    }

    private static long sizeOfTEndPoint(TEndPoint tEndPoint) {
        if (tEndPoint == null) {
            return 0L;
        }
        long size = T_END_POINT_SIZE;
        return size += InsertNodeMemoryEstimator.sizeOfString(tEndPoint.ip);
    }

    private static long sizeOfTSStatus(TSStatus tSStatus) {
        if (tSStatus == null) {
            return 0L;
        }
        long size = TS_STATUS_SIZE;
        if (tSStatus.isSetMessage()) {
            size += InsertNodeMemoryEstimator.sizeOfString(tSStatus.message);
        }
        if (tSStatus.isSetRedirectNode()) {
            size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tSStatus.redirectNode);
        }
        return size;
    }

    private static long sizeOfProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return 0L;
        }
        switch (progressIndex.getType()) {
            case HYBRID_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfHybridProgressIndex((HybridProgressIndex)progressIndex);
            }
            case IOT_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfIoTProgressIndex((IoTProgressIndex)progressIndex);
            }
            case META_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfMetaProgressIndex();
            }
            case STATE_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfStateProgressIndex((StateProgressIndex)progressIndex);
            }
            case SIMPLE_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfSimpleProgressIndex();
            }
            case MINIMUM_PROGRESS_INDEX: {
                return 0L;
            }
            case RECOVER_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfRecoverProgressIndex((RecoverProgressIndex)progressIndex);
            }
            case TIME_WINDOW_STATE_PROGRESS_INDEX: {
                return InsertNodeMemoryEstimator.sizeOfTimeWindowStateProgressIndex((TimeWindowStateProgressIndex)progressIndex);
            }
        }
        return 0L;
    }

    private static long sizeOfHybridProgressIndex(HybridProgressIndex progressIndex) {
        long size = HYBRID_PROGRESS_INDEX_SIZE;
        size += REENTRANT_READ_WRITE_LOCK_SIZE;
        if (progressIndex.getType2Index() != null) {
            size += NUM_BYTES_OBJECT_HEADER + (long)progressIndex.getType2Index().size() * (SIZE_OF_SHORT + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
        }
        return size;
    }

    private static long sizeOfIoTProgressIndex(IoTProgressIndex progressIndex) {
        long size = IOT_PROGRESS_INDEX_SIZE;
        size += REENTRANT_READ_WRITE_LOCK_SIZE;
        return size += NUM_BYTES_OBJECT_HEADER + (long)progressIndex.getPeerId2SearchIndexSize() * (SIZE_OF_INT + SIZE_OF_LONG + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
    }

    private static long sizeOfMetaProgressIndex() {
        return META_PROGRESS_INDEX_SIZE + REENTRANT_READ_WRITE_LOCK_SIZE;
    }

    private static long sizeOfRecoverProgressIndex(RecoverProgressIndex progressIndex) {
        long size = RECOVER_PROGRESS_INDEX_SIZE;
        size += REENTRANT_READ_WRITE_LOCK_SIZE;
        if (progressIndex.getDataNodeId2LocalIndex() != null) {
            size += NUM_BYTES_OBJECT_HEADER + (long)progressIndex.getDataNodeId2LocalIndex().size() * (SIZE_OF_INT + SIZE_OF_LONG + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
        }
        return size;
    }

    private static long sizeOfSimpleProgressIndex() {
        return SIMPLE_PROGRESS_INDEX_SIZE;
    }

    private static long sizeOfStateProgressIndex(StateProgressIndex progressIndex) {
        long size = STATE_PROGRESS_INDEX_SIZE;
        size += REENTRANT_READ_WRITE_LOCK_SIZE;
        if (progressIndex.getState() != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry entry : progressIndex.getState().entrySet()) {
                size += RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + InsertNodeMemoryEstimator.sizeOfString((String)entry.getKey()) + InsertNodeMemoryEstimator.sizeOfBinary((Binary)entry.getValue());
            }
        }
        return size;
    }

    private static long sizeOfTimeWindowStateProgressIndex(TimeWindowStateProgressIndex progressIndex) {
        long size = TIME_WINDOW_STATE_PROGRESS_INDEX_SIZE;
        size += REENTRANT_READ_WRITE_LOCK_SIZE;
        if (progressIndex.getTimeSeries2TimestampWindowBufferPairMap() != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry entry : progressIndex.getTimeSeries2TimestampWindowBufferPairMap().entrySet()) {
                size += InsertNodeMemoryEstimator.sizeOfString((String)entry.getKey()) + SIZE_OF_LONG * 2L + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
        }
        return size;
    }

    private static long sizeOfBinary(Binary binary) {
        if (binary == null) {
            return 0L;
        }
        return RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_OBJECT_HEADER + NUM_BYTES_OBJECT_REF)) + RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + (long)binary.getValues().length));
    }

    private static long sizeOfString(String value) {
        if (value == null) {
            return 0L;
        }
        return SIZE_OF_STRING + RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + (long)value.length()));
    }

    private static long sizeOfStringArray(String[] values) {
        if (values == null) {
            return 0L;
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + (long)values.length * NUM_BYTES_OBJECT_REF));
        for (String value : values) {
            size += InsertNodeMemoryEstimator.sizeOfString(value);
        }
        return size;
    }

    private static long sizeOfTimes(long[] times) {
        if (times == null) {
            return 0L;
        }
        long size = NUM_BYTES_ARRAY_HEADER + 8L * (long)times.length;
        return RamUsageEstimator.alignObjectSize((long)size);
    }

    private static long sizeOfBitMapArray(BitMap[] bitMaps) {
        if (bitMaps == null) {
            return 0L;
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)bitMaps.length));
        for (BitMap bitMap : bitMaps) {
            size += InsertNodeMemoryEstimator.sizeOfBitMap(bitMap);
        }
        return size;
    }

    private static long sizeOfBitMap(BitMap bitMaps) {
        if (bitMaps == null) {
            return 0L;
        }
        long size = BIT_MAP_SIZE;
        return size += RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + (long)bitMaps.getByteArray().length));
    }

    private static long sizeOfColumns(Object[] columns, MeasurementSchema[] measurementSchemas) {
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)columns.length));
        block8: for (int i = 0; i < columns.length; ++i) {
            switch (measurementSchemas[i].getType()) {
                case INT64: 
                case TIMESTAMP: {
                    size += RamUsageEstimator.sizeOf((long[])((long[])columns[i]));
                    continue block8;
                }
                case DATE: 
                case INT32: {
                    size += RamUsageEstimator.sizeOf((int[])((int[])columns[i]));
                    continue block8;
                }
                case DOUBLE: {
                    size += RamUsageEstimator.sizeOf((double[])((double[])columns[i]));
                    continue block8;
                }
                case FLOAT: {
                    size += RamUsageEstimator.sizeOf((float[])((float[])columns[i]));
                    continue block8;
                }
                case BOOLEAN: {
                    size += RamUsageEstimator.sizeOf((boolean[])((boolean[])columns[i]));
                    continue block8;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    Binary[] values = (Binary[])columns[i];
                    size += RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)values.length));
                    for (Binary value : values) {
                        size += InsertNodeMemoryEstimator.sizeOfBinary(value);
                    }
                    continue block8;
                }
            }
        }
        return size;
    }

    private static long sizeOfValues(Object[] columns, MeasurementSchema[] measurementSchemas) {
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)columns.length));
        block8: for (int i = 0; i < columns.length; ++i) {
            switch (measurementSchemas[i].getType()) {
                case INT64: 
                case TIMESTAMP: {
                    size += SIZE_OF_LONG;
                    continue block8;
                }
                case DATE: 
                case INT32: {
                    size += SIZE_OF_INT;
                    continue block8;
                }
                case DOUBLE: {
                    size += SIZE_OF_DOUBLE;
                    continue block8;
                }
                case FLOAT: {
                    size += SIZE_OF_FLOAT;
                    continue block8;
                }
                case BOOLEAN: {
                    size += SIZE_OF_BOOLEAN;
                    continue block8;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    Binary binary = (Binary)columns[i];
                    size += InsertNodeMemoryEstimator.sizeOfBinary(binary);
                }
            }
        }
        return size;
    }
}

