/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.thrift;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.common.PipeTransferSliceReqHandler;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV1;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferSliceReq;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.receiver.IoTDBFileReceiver;
import org.apache.iotdb.commons.pipe.receiver.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeReceiverMetrics;
import org.apache.iotdb.db.pipe.receiver.visitor.PipePlanToStatementVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementExceptionVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementPatternParseVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementTSStatusVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementToBatchVisitor;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.tools.schema.SRStatementGenerator;
import org.apache.iotdb.db.tools.schema.SchemaRegionSnapshotParser;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataNodeReceiver
extends IoTDBFileReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeReceiver.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String[] RECEIVER_FILE_BASE_DIRS = IOTDB_CONFIG.getPipeReceiverFileDirs();
    private static FolderManager folderManager = null;
    public static final PipePlanToStatementVisitor PLAN_TO_STATEMENT_VISITOR = new PipePlanToStatementVisitor();
    private static final PipeStatementTSStatusVisitor STATEMENT_STATUS_VISITOR = new PipeStatementTSStatusVisitor();
    private static final PipeStatementExceptionVisitor STATEMENT_EXCEPTION_VISITOR = new PipeStatementExceptionVisitor();
    private static final PipeStatementPatternParseVisitor STATEMENT_PATTERN_PARSE_VISITOR = new PipeStatementPatternParseVisitor();
    private static final PipeStatementDataTypeConvertExecutionVisitor STATEMENT_DATA_TYPE_CONVERT_EXECUTION_VISITOR = new PipeStatementDataTypeConvertExecutionVisitor(IoTDBDataNodeReceiver::executeStatement);
    private final PipeStatementToBatchVisitor batchVisitor = new PipeStatementToBatchVisitor();
    private static final AtomicLong CONFIG_RECEIVER_ID_GENERATOR = new AtomicLong(0L);
    protected final AtomicReference<String> configReceiverId = new AtomicReference();
    private final PipeTransferSliceReqHandler sliceReqHandler = new PipeTransferSliceReqHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized TPipeTransferResp receive(TPipeTransferReq req) {
        try {
            long startTime = System.nanoTime();
            short rawRequestType = req.getType();
            if (PipeRequestType.isValidatedRequestType((short)rawRequestType)) {
                PipeRequestType requestType = PipeRequestType.valueOf((short)rawRequestType);
                if (requestType != PipeRequestType.TRANSFER_SLICE) {
                    this.sliceReqHandler.clear();
                }
                switch (requestType) {
                    case HANDSHAKE_DATANODE_V1: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferHandshakeV1(PipeTransferDataNodeHandshakeV1Req.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordHandshakeDatanodeV1Timer(System.nanoTime() - startTime);
                        }
                    }
                    case HANDSHAKE_DATANODE_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferHandshakeV2(PipeTransferDataNodeHandshakeV2Req.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordHandshakeDatanodeV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_INSERT_NODE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletInsertNode(PipeTransferTabletInsertNodeReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletInsertNodeTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_RAW: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletRaw(PipeTransferTabletRawReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletRawTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BINARY: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBinary(PipeTransferTabletBinaryReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBinaryTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BATCH: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBatch(PipeTransferTabletBatchReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBatchTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_PIECE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferTsFilePieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, true);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFilePieceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV1(PipeTransferTsFileSealReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFileSealTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_PIECE_WITH_MOD: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferTsFilePieceWithModReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFilePieceWithModTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_SEAL_WITH_MOD: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV2(PipeTransferTsFileSealWithModReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFileSealWithModTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SCHEMA_PLAN: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferSchemaPlan(PipeTransferPlanNodeReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaPlanTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SCHEMA_SNAPSHOT_PIECE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferSchemaSnapshotPieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaSnapshotPieceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SCHEMA_SNAPSHOT_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV2(PipeTransferSchemaSnapshotSealReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaSnapshotSealTimer(System.nanoTime() - startTime);
                        }
                    }
                    case HANDSHAKE_CONFIGNODE_V1: 
                    case HANDSHAKE_CONFIGNODE_V2: 
                    case TRANSFER_CONFIG_PLAN: 
                    case TRANSFER_CONFIG_SNAPSHOT_PIECE: 
                    case TRANSFER_CONFIG_SNAPSHOT_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferConfigPlan(req);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferConfigPlanTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SLICE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferSlice(PipeTransferSliceReq.fromTPipeTransferReq((TPipeTransferReq)req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSliceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_COMPRESSED: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.receive(PipeTransferCompressedReq.fromTPipeTransferReq((TPipeTransferReq)req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferCompressedTimer(System.nanoTime() - startTime);
                        }
                    }
                }
            }
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unknown PipeRequestType %s.", rawRequestType));
            LOGGER.warn("Receiver id = {}: Unknown PipeRequestType, response status = {}.", (Object)this.receiverId.get(), (Object)status);
            return new TPipeTransferResp(status);
        }
        catch (Exception e) {
            String error = String.format("Exception %s encountered while handling request %s.", e.getMessage(), req);
            LOGGER.warn("Receiver id = {}: {}", new Object[]{this.receiverId.get(), error, e});
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)error));
        }
    }

    private TPipeTransferResp handleTransferTabletInsertNode(PipeTransferTabletInsertNodeReq req) {
        InsertBaseStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletBinary(PipeTransferTabletBinaryReq req) {
        InsertBaseStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletRaw(PipeTransferTabletRawReq req) {
        InsertTabletStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletBatch(PipeTransferTabletBatchReq req) {
        Pair<InsertRowsStatement, InsertMultiTabletsStatement> statementPair = req.constructStatements();
        return new TPipeTransferResp(PipeReceiverStatusHandler.getPriorStatus(Stream.of(((InsertRowsStatement)statementPair.getLeft()).isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndAddRedirectInfo((InsertBaseStatement)statementPair.getLeft()), ((InsertMultiTabletsStatement)statementPair.getRight()).isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndAddRedirectInfo((InsertBaseStatement)statementPair.getRight())).collect(Collectors.toList())));
    }

    protected String getClusterId() {
        return IoTDBDescriptor.getInstance().getConfig().getClusterId();
    }

    protected String getReceiverFileBaseDir() throws DiskSpaceInsufficientException {
        return Objects.isNull(folderManager) ? null : folderManager.getNextFolder();
    }

    protected TSStatus loadFileV1(PipeTransferFileSealReqV1 req, String fileAbsolutePath) throws IOException {
        return this.isUsingAsyncLoadTsFileStrategy.get() ? this.loadTsFileAsync(Collections.singletonList(fileAbsolutePath)) : this.loadTsFileSync(fileAbsolutePath);
    }

    protected TSStatus loadFileV2(PipeTransferFileSealReqV2 req, List<String> fileAbsolutePaths) throws IOException, IllegalPathException {
        return req instanceof PipeTransferTsFileSealWithModReq ? (this.isUsingAsyncLoadTsFileStrategy.get() ? this.loadTsFileAsync(fileAbsolutePaths) : this.loadTsFileSync(fileAbsolutePaths.get(1))) : this.loadSchemaSnapShot(req.getParameters(), fileAbsolutePaths);
    }

    private TSStatus loadTsFileAsync(List<String> absolutePaths) throws IOException {
        String loadActiveListeningPipeDir = IOTDB_CONFIG.getLoadActiveListeningPipeDir();
        for (String absolutePath : absolutePaths) {
            File sourceFile;
            if (absolutePath == null || Objects.equals(loadActiveListeningPipeDir, (sourceFile = new File(absolutePath)).getParentFile().getAbsolutePath())) continue;
            FileUtils.moveFileWithMD5Check((File)sourceFile, (File)new File(loadActiveListeningPipeDir));
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus loadTsFileSync(String fileAbsolutePath) throws FileNotFoundException {
        LoadTsFileStatement statement = new LoadTsFileStatement(fileAbsolutePath);
        statement.setDeleteAfterLoad(true);
        statement.setVerifySchema(true);
        statement.setAutoCreateDatabase(false);
        return this.executeStatementAndClassifyExceptions(statement);
    }

    private TSStatus loadSchemaSnapShot(Map<String, String> parameters, List<String> fileAbsolutePaths) throws IllegalPathException, IOException {
        SRStatementGenerator generator = SchemaRegionSnapshotParser.translate2Statements(Paths.get(fileAbsolutePaths.get(0), new String[0]), fileAbsolutePaths.size() > 1 ? Paths.get(fileAbsolutePaths.get(1), new String[0]) : null, new PartialPath(parameters.get("Database")));
        Set<StatementType> executionTypes = PipeSchemaRegionSnapshotEvent.getStatementTypeSet(parameters.get("Type"));
        IoTDBPipePattern pattern = new IoTDBPipePattern(parameters.get("PathPattern"));
        this.batchVisitor.clear();
        ArrayList results = new ArrayList();
        while (generator.hasNext()) {
            Statement originalStatement = generator.next();
            if (!executionTypes.contains((Object)originalStatement.getType())) continue;
            ((Optional)STATEMENT_PATTERN_PARSE_VISITOR.process(originalStatement, pattern)).flatMap(parsedStatement -> (Optional)this.batchVisitor.process((StatementNode)parsedStatement, null)).ifPresent(statement -> results.add(this.executeStatementAndClassifyExceptions((Statement)statement)));
        }
        this.batchVisitor.getRemainBatches().stream().filter(Optional::isPresent).forEach(statement -> results.add(this.executeStatementAndClassifyExceptions((Statement)statement.get())));
        return PipeReceiverStatusHandler.getPriorStatus(results);
    }

    private TPipeTransferResp handleTransferSchemaPlan(PipeTransferPlanNodeReq req) {
        return req.getPlanNode() instanceof AlterLogicalViewNode ? new TPipeTransferResp(ClusterConfigTaskExecutor.getInstance().alterLogicalViewByPipe((AlterLogicalViewNode)req.getPlanNode())) : new TPipeTransferResp(this.executeStatementAndClassifyExceptions((Statement)PLAN_TO_STATEMENT_VISITOR.process(req.getPlanNode(), null)));
    }

    private TPipeTransferResp handleTransferConfigPlan(TPipeTransferReq req) {
        return ClusterConfigTaskExecutor.getInstance().handleTransferConfigPlan(this.getConfigReceiverId(), req);
    }

    private String getConfigReceiverId() {
        if (Objects.isNull(this.configReceiverId.get())) {
            this.configReceiverId.set(IoTDBDescriptor.getInstance().getConfig().getDataNodeId() + "_" + PipeDataNodeAgent.runtime().getRebootTimes() + "_" + CONFIG_RECEIVER_ID_GENERATOR.incrementAndGet());
        }
        return this.configReceiverId.get();
    }

    private TPipeTransferResp handleTransferSlice(PipeTransferSliceReq pipeTransferSliceReq) {
        boolean isInorder = this.sliceReqHandler.receiveSlice(pipeTransferSliceReq);
        if (!isInorder) {
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_SLICE_OUT_OF_ORDER, (String)"Slice request is out of order, please check the request sequence."));
        }
        Optional req = this.sliceReqHandler.makeReqIfComplete();
        if (!req.isPresent()) {
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Slice received, waiting for more slices to complete the request."));
        }
        return this.receive((TPipeTransferReq)req.get());
    }

    private TSStatus executeStatementAndAddRedirectInfo(InsertBaseStatement statement) {
        TSStatus result = this.executeStatementAndClassifyExceptions(statement);
        if (result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && result.getSubStatusSize() > 0) {
            List<PartialPath> devicePaths;
            if (statement instanceof InsertRowsStatement) {
                devicePaths = ((InsertRowsStatement)statement).getDevicePaths();
            } else if (statement instanceof InsertMultiTabletsStatement) {
                devicePaths = ((InsertMultiTabletsStatement)statement).getDevicePaths();
            } else {
                LOGGER.warn("Receiver id = {}: Unsupported statement type {} for redirection.", (Object)this.receiverId.get(), (Object)statement);
                return result;
            }
            if (devicePaths.size() == result.getSubStatusSize()) {
                for (int i = 0; i < devicePaths.size(); ++i) {
                    if (!((TSStatus)result.getSubStatus().get(i)).isSetRedirectNode()) continue;
                    ((TSStatus)result.getSubStatus().get(i)).setMessage(devicePaths.get(i).getFullPath());
                }
            } else {
                LOGGER.warn("Receiver id = {}: The number of device paths is not equal to sub-status in statement {}: {}.", new Object[]{this.receiverId.get(), statement, result});
            }
        }
        return result;
    }

    private TSStatus executeStatementAndClassifyExceptions(Statement statement) {
        try {
            TSStatus result = this.executeStatementWithRetryOnDataTypeMismatch(statement);
            if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                return result;
            }
            LOGGER.warn("Receiver id = {}: Failure status encountered while executing statement {}: {}", new Object[]{this.receiverId.get(), statement, result});
            return statement.accept(STATEMENT_STATUS_VISITOR, result);
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Exception encountered while executing statement {}: ", new Object[]{this.receiverId.get(), statement, e});
            return statement.accept(STATEMENT_EXCEPTION_VISITOR, e);
        }
    }

    private TSStatus executeStatementWithRetryOnDataTypeMismatch(Statement statement) {
        if (statement == null) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_EXECUTE_STATEMENT_ERROR, (String)"Execute null statement.");
        }
        TSStatus status = IoTDBDataNodeReceiver.executeStatement(statement);
        return this.shouldConvertDataTypeOnTypeMismatch && (statement instanceof InsertBaseStatement && ((InsertBaseStatement)statement).hasFailedMeasurements() || status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) ? statement.accept(STATEMENT_DATA_TYPE_CONVERT_EXECUTION_VISITOR, status).orElse(status) : status;
    }

    private static TSStatus executeStatement(Statement statement) {
        return Coordinator.getInstance().executeForTreeModel((Statement)new PipeEnrichedStatement((Statement)statement), (long)SessionManager.getInstance().requestQueryId(), (SessionInfo)new SessionInfo((long)0L, (String)AuthorityChecker.SUPER_USER, (ZoneId)ZoneId.systemDefault()), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold()).status;
    }

    public synchronized void handleExit() {
        if (Objects.nonNull(this.configReceiverId.get())) {
            try {
                ClusterConfigTaskExecutor.getInstance().handlePipeConfigClientExit(this.configReceiverId.get());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to handle config client (id = {}) exit", (Object)this.configReceiverId.get(), (Object)e);
            }
        }
        super.handleExit();
    }

    static {
        try {
            folderManager = new FolderManager(Arrays.asList(RECEIVER_FILE_BASE_DIRS), DirectoryStrategyType.SEQUENCE_STRATEGY);
        }
        catch (DiskSpaceInsufficientException e) {
            LOGGER.error("Fail to create pipe receiver file folders allocation strategy because all disks of folders are full.", (Throwable)((Object)e));
        }
    }
}

