/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import org.apache.iotdb.commons.concurrent.IoTDBDaemonThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.DisruptorQueueExceptionHandler;
import org.apache.iotdb.db.pipe.metric.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.pipe.api.event.Event;

public class DisruptorQueue {
    private static final IoTDBDaemonThreadFactory THREAD_FACTORY = new IoTDBDaemonThreadFactory(ThreadName.PIPE_EXTRACTOR_DISRUPTOR.getName());
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final Disruptor<EventContainer> disruptor;
    private final RingBuffer<EventContainer> ringBuffer;
    private final PipeEventCounter eventCounter = new PipeDataRegionEventCounter();

    public DisruptorQueue(EventHandler<PipeRealtimeEvent> eventHandler) {
        PipeConfig config = PipeConfig.getInstance();
        int ringBufferSize = config.getPipeExtractorAssignerDisruptorRingBufferSize();
        long ringBufferEntrySizeInBytes = config.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes();
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate((long)ringBufferSize * ringBufferEntrySizeInBytes, currentSize -> currentSize / 2L);
        this.disruptor = new Disruptor(() -> new EventContainer(), Math.max(32, Math.toIntExact(this.allocatedMemoryBlock.getMemoryUsageInBytes() / ringBufferEntrySizeInBytes)), (ThreadFactory)THREAD_FACTORY, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{(container, sequence, endOfBatch) -> {
            eventHandler.onEvent((Object)container.getEvent(), sequence, endOfBatch);
            EnrichedEvent innerEvent = container.getEvent().getEvent();
            this.eventCounter.decreaseEventCount((Event)innerEvent);
        }});
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new DisruptorQueueExceptionHandler());
        this.ringBuffer = this.disruptor.start();
    }

    public void publish(PipeRealtimeEvent event) {
        EnrichedEvent internalEvent = event.getEvent();
        if (internalEvent instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)internalEvent).recordDisruptorSize(this.ringBuffer);
        }
        this.ringBuffer.publishEvent((container, sequence, o) -> container.setEvent(event), (Object)event);
        this.eventCounter.increaseEventCount((Event)internalEvent);
    }

    public void clear() {
        this.disruptor.halt();
        this.allocatedMemoryBlock.close();
    }

    public int getTabletInsertionEventCount() {
        return this.eventCounter.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.eventCounter.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.eventCounter.getPipeHeartbeatEventCount();
    }

    private static class EventContainer {
        private PipeRealtimeEvent event;

        private EventContainer() {
        }

        public PipeRealtimeEvent getEvent() {
            return this.event;
        }

        public void setEvent(PipeRealtimeEvent event) {
            this.event = event;
        }
    }
}

