/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeDispatcher;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsensusPipeDataNodeDispatcher
implements ConsensusPipeDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsensusPipeDataNodeDispatcher.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();

    public void createPipe(String pipeName, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreatePipeReq req = new TCreatePipeReq().setPipeName(pipeName).setExtractorAttributes(extractorAttributes).setProcessorAttributes(processorAttributes).setConnectorAttributes(connectorAttributes);
            TSStatus status = configNodeClient.createPipe(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                LOGGER.warn("Failed to create consensus pipe-{}, status: {}", (Object)pipeName, (Object)status);
                throw new PipeException(status.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create consensus pipe-{}", (Object)pipeName);
            throw new PipeException("Failed to create consensus pipe", (Throwable)e);
        }
    }

    public void startPipe(String pipeName) throws Exception {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus status = configNodeClient.startPipe(pipeName);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                LOGGER.warn("Failed to start consensus pipe-{}, status: {}", (Object)pipeName, (Object)status);
                throw new PipeException(status.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to start consensus pipe-{}", (Object)pipeName);
            throw new PipeException("Failed to start consensus pipe", (Throwable)e);
        }
    }

    public void stopPipe(String pipeName) throws Exception {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus status = configNodeClient.stopPipe(pipeName);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                LOGGER.warn("Failed to stop consensus pipe-{}, status: {}", (Object)pipeName, (Object)status);
                throw new PipeException(status.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to stop consensus pipe-{}", (Object)pipeName);
            throw new PipeException("Failed to stop consensus pipe", (Throwable)e);
        }
    }

    public void dropPipe(ConsensusPipeName pipeName) throws Exception {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus status = configNodeClient.dropPipe(pipeName.toString());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                LOGGER.warn("Failed to drop consensus pipe-{}, status: {}", (Object)pipeName, (Object)status);
                throw new PipeException(status.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to drop consensus pipe-{}", (Object)pipeName);
            throw new PipeException("Failed to drop consensus pipe", (Throwable)e);
        }
        PipeDataNodeAgent.receiver().pipeConsensus().handleDropPipeConsensusTask(pipeName);
    }
}

