/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.exception.write.NoMeasurementException;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.MeasurementGroup;
import org.apache.tsfile.write.chunk.AlignedChunkGroupWriterImpl;
import org.apache.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.tsfile.write.chunk.NonAlignedChunkGroupWriterImpl;
import org.apache.tsfile.write.record.TSRecord;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.Schema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.apache.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileWriter
implements AutoCloseable {
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final Logger LOG = LoggerFactory.getLogger(TsFileWriter.class);
    protected final Schema schema;
    private final TsFileIOWriter fileWriter;
    private final int pageSize;
    private long recordCount = 0L;
    private Map<IDeviceID, List<String>> flushedMeasurementsInDeviceMap = new HashMap<IDeviceID, List<String>>();
    private Map<IDeviceID, Long> alignedDeviceLastTimeMap = new HashMap<IDeviceID, Long>();
    private Map<IDeviceID, Map<String, Long>> nonAlignedTimeseriesLastTimeMap = new HashMap<IDeviceID, Map<String, Long>>();
    private boolean isUnseq = false;
    private Map<IDeviceID, IChunkGroupWriter> groupWriters = new HashMap<IDeviceID, IChunkGroupWriter>();
    private long recordCountForNextMemCheck = 100L;
    private long chunkGroupSizeThreshold;

    public TsFileWriter(File file) throws IOException {
        this(new TsFileIOWriter(file), new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileIOWriter fileWriter) throws IOException {
        this(fileWriter, new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema) throws IOException {
        this(new TsFileIOWriter(file), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileOutput output, Schema schema) throws IOException {
        this(new TsFileIOWriter(output), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema, TSFileConfig conf) throws IOException {
        this(new TsFileIOWriter(file), schema, conf);
    }

    protected TsFileWriter(TsFileIOWriter fileWriter, Schema schema, TSFileConfig conf) throws IOException {
        if (!fileWriter.canWrite()) {
            throw new IOException("the given file Writer does not support writing any more. Maybe it is an complete TsFile");
        }
        this.fileWriter = fileWriter;
        if (fileWriter instanceof RestorableTsFileIOWriter) {
            Map<Path, IMeasurementSchema> schemaMap = ((RestorableTsFileIOWriter)fileWriter).getKnownSchema();
            HashMap<Path, MeasurementGroup> measurementGroupMap = new HashMap<Path, MeasurementGroup>();
            for (Map.Entry<Path, IMeasurementSchema> entry : schemaMap.entrySet()) {
                MeasurementGroup group;
                IMeasurementSchema measurementSchema = entry.getValue();
                if (measurementSchema instanceof VectorMeasurementSchema) {
                    group = measurementGroupMap.getOrDefault(new Path(entry.getKey().getDevice()), new MeasurementGroup(true));
                    List<String> measurementList = measurementSchema.getSubMeasurementsList();
                    for (int i = 0; i < measurementList.size(); ++i) {
                        group.getMeasurementSchemaMap().put(measurementList.get(i), new MeasurementSchema(measurementList.get(i), measurementSchema.getSubMeasurementsTSDataTypeList().get(i), measurementSchema.getSubMeasurementsTSEncodingList().get(i)));
                    }
                    measurementGroupMap.put(new Path(entry.getKey().getDevice()), group);
                    continue;
                }
                group = measurementGroupMap.getOrDefault(new Path(entry.getKey().getDevice()), new MeasurementGroup(false));
                group.getMeasurementSchemaMap().put(measurementSchema.getMeasurementId(), (MeasurementSchema)measurementSchema);
                measurementGroupMap.put(new Path(entry.getKey().getDevice()), group);
            }
            this.schema = new Schema(measurementGroupMap);
        } else {
            this.schema = schema;
        }
        this.pageSize = conf.getPageSizeInByte();
        this.chunkGroupSizeThreshold = conf.getGroupSizeInByte();
        config.setTSFileStorageFs(conf.getTSFileStorageFs());
        if ((long)this.pageSize >= this.chunkGroupSizeThreshold) {
            LOG.warn("TsFile's page size {} is greater than chunk group size {}, please enlarge the chunk group size or decrease page size. ", (Object)this.pageSize, (Object)this.chunkGroupSizeThreshold);
        }
    }

    public void registerSchemaTemplate(String templateName, Map<String, MeasurementSchema> template, boolean isAligned) {
        this.schema.registerSchemaTemplate(templateName, new MeasurementGroup(isAligned, template));
    }

    public void registerDevice(String deviceId, String templateName) throws WriteProcessException {
        if (!this.schema.getSchemaTemplates().containsKey(templateName)) {
            throw new WriteProcessException("given template is not existed! " + templateName);
        }
        if (this.schema.getRegisteredTimeseriesMap().containsKey(new Path(deviceId))) {
            throw new WriteProcessException("this device " + deviceId + " has been registered, you can only use registerDevice method to register empty device.");
        }
        this.schema.registerDevice(deviceId, templateName);
    }

    public void registerTimeseries(Path devicePath, MeasurementSchema measurementSchema) throws WriteProcessException {
        MeasurementGroup measurementGroup;
        if (this.schema.containsDevice(devicePath)) {
            measurementGroup = this.schema.getSeriesSchema(devicePath);
            if (measurementGroup.isAligned()) {
                throw new WriteProcessException("given device " + devicePath + " has been registered for aligned timeseries.");
            }
            if (measurementGroup.getMeasurementSchemaMap().containsKey(measurementSchema.getMeasurementId())) {
                throw new WriteProcessException("given nonAligned timeseries " + devicePath + "." + measurementSchema.getMeasurementId() + " has been registered.");
            }
        } else {
            measurementGroup = new MeasurementGroup(false);
        }
        measurementGroup.getMeasurementSchemaMap().put(measurementSchema.getMeasurementId(), measurementSchema);
        this.schema.registerMeasurementGroup(devicePath, measurementGroup);
    }

    public void registerTimeseries(Path devicePath, List<MeasurementSchema> measurementSchemas) {
        for (MeasurementSchema schema : measurementSchemas) {
            try {
                this.registerTimeseries(devicePath, schema);
            }
            catch (WriteProcessException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    public void registerAlignedTimeseries(Path devicePath, List<MeasurementSchema> measurementSchemas) throws WriteProcessException {
        if (this.schema.containsDevice(devicePath)) {
            if (this.schema.getSeriesSchema(devicePath).isAligned()) {
                throw new WriteProcessException("given device " + devicePath + " has been registered for aligned timeseries and should not be expanded.");
            }
            throw new WriteProcessException("given device " + devicePath + " has been registered for nonAligned timeseries.");
        }
        MeasurementGroup measurementGroup = new MeasurementGroup(true);
        measurementSchemas.forEach(measurementSchema -> measurementGroup.getMeasurementSchemaMap().put(measurementSchema.getMeasurementId(), (MeasurementSchema)measurementSchema));
        this.schema.registerMeasurementGroup(devicePath, measurementGroup);
    }

    private boolean checkIsTimeseriesExist(TSRecord record, boolean isAligned) throws WriteProcessException, IOException {
        IChunkGroupWriter groupWriter = this.tryToInitialGroupWriter(new PlainDeviceID(record.deviceId), isAligned);
        Path devicePath = new Path(record.deviceId);
        if (this.schema.containsDevice(devicePath)) {
            List<MeasurementSchema> measurementSchemas = this.checkIsAllMeasurementsInGroup(record.dataPointList, this.schema.getSeriesSchema(devicePath), isAligned);
            if (isAligned) {
                for (IMeasurementSchema iMeasurementSchema : measurementSchemas) {
                    if (!this.flushedMeasurementsInDeviceMap.containsKey(new PlainDeviceID(devicePath.getFullPath())) || this.flushedMeasurementsInDeviceMap.get(new PlainDeviceID(devicePath.getFullPath())).contains(iMeasurementSchema.getMeasurementId())) continue;
                    throw new WriteProcessException("TsFile has flushed chunk group and should not add new measurement " + iMeasurementSchema.getMeasurementId() + " in device " + devicePath.getFullPath());
                }
            }
            groupWriter.tryToAddSeriesWriter(measurementSchemas);
        } else if (this.schema.getSchemaTemplates() != null && this.schema.getSchemaTemplates().size() == 1) {
            MeasurementGroup measurementGroup = this.schema.getSchemaTemplates().entrySet().iterator().next().getValue();
            List<MeasurementSchema> measurementSchemas = this.checkIsAllMeasurementsInGroup(record.dataPointList, measurementGroup, isAligned);
            groupWriter.tryToAddSeriesWriter(measurementSchemas);
        } else {
            throw new NoMeasurementException("input devicePath is invalid: " + devicePath);
        }
        return true;
    }

    private void checkIsTimeseriesExist(Tablet tablet, boolean isAligned) throws WriteProcessException, IOException {
        IChunkGroupWriter groupWriter = this.tryToInitialGroupWriter(new PlainDeviceID(tablet.deviceId), isAligned);
        Path devicePath = new Path(tablet.deviceId);
        List<MeasurementSchema> schemas = tablet.getSchemas();
        if (this.schema.containsDevice(devicePath)) {
            this.checkIsAllMeasurementsInGroup(this.schema.getSeriesSchema(devicePath), schemas, isAligned);
            if (isAligned) {
                for (IMeasurementSchema iMeasurementSchema : schemas) {
                    if (!this.flushedMeasurementsInDeviceMap.containsKey(new PlainDeviceID(devicePath.getFullPath())) || this.flushedMeasurementsInDeviceMap.get(new PlainDeviceID(devicePath.getFullPath())).contains(iMeasurementSchema.getMeasurementId())) continue;
                    throw new WriteProcessException("TsFile has flushed chunk group and should not add new measurement " + iMeasurementSchema.getMeasurementId() + " in device " + devicePath.getFullPath());
                }
            }
            groupWriter.tryToAddSeriesWriter(schemas);
        } else if (this.schema.getSchemaTemplates() != null && this.schema.getSchemaTemplates().size() == 1) {
            MeasurementGroup measurementGroup = this.schema.getSchemaTemplates().entrySet().iterator().next().getValue();
            this.checkIsAllMeasurementsInGroup(measurementGroup, schemas, isAligned);
            groupWriter.tryToAddSeriesWriter(schemas);
        } else {
            throw new NoMeasurementException("input devicePath is invalid: " + devicePath);
        }
    }

    private void checkIsAllMeasurementsInGroup(MeasurementGroup measurementGroup, List<MeasurementSchema> measurementSchemas, boolean isAligned) throws NoMeasurementException {
        if (isAligned && !measurementGroup.isAligned()) {
            throw new NoMeasurementException("no aligned timeseries is registered in the group.");
        }
        if (!isAligned && measurementGroup.isAligned()) {
            throw new NoMeasurementException("no nonAligned timeseries is registered in the group.");
        }
        for (MeasurementSchema measurementSchema : measurementSchemas) {
            if (measurementGroup.getMeasurementSchemaMap().containsKey(measurementSchema.getMeasurementId())) continue;
            if (isAligned) {
                throw new NoMeasurementException("measurement " + measurementSchema.getMeasurementId() + " is not registered or in the default template");
            }
            measurementSchemas.remove(measurementSchema);
        }
    }

    private List<MeasurementSchema> checkIsAllMeasurementsInGroup(List<DataPoint> dataPoints, MeasurementGroup measurementGroup, boolean isAligned) throws NoMeasurementException {
        if (isAligned && !measurementGroup.isAligned()) {
            throw new NoMeasurementException("no aligned timeseries is registered in the group.");
        }
        if (!isAligned && measurementGroup.isAligned()) {
            throw new NoMeasurementException("no nonAligned timeseries is registered in the group.");
        }
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        for (DataPoint dataPoint : dataPoints) {
            if (!measurementGroup.getMeasurementSchemaMap().containsKey(dataPoint.getMeasurementId())) {
                if (isAligned) {
                    throw new NoMeasurementException("aligned measurement " + dataPoint.getMeasurementId() + " is not registered or in the default template");
                }
                LOG.warn("Ignore nonAligned measurement " + dataPoint.getMeasurementId() + " , because it is not registered or in the default template");
                continue;
            }
            schemas.add(measurementGroup.getMeasurementSchemaMap().get(dataPoint.getMeasurementId()));
        }
        return schemas;
    }

    private IChunkGroupWriter tryToInitialGroupWriter(IDeviceID deviceId, boolean isAligned) {
        IChunkGroupWriter groupWriter;
        if (!this.groupWriters.containsKey(deviceId)) {
            if (isAligned) {
                groupWriter = new AlignedChunkGroupWriterImpl(deviceId);
                if (!this.isUnseq) {
                    ((AlignedChunkGroupWriterImpl)groupWriter).setLastTime(this.alignedDeviceLastTimeMap.getOrDefault(deviceId, -1L));
                }
            } else {
                groupWriter = new NonAlignedChunkGroupWriterImpl(deviceId);
                if (!this.isUnseq) {
                    ((NonAlignedChunkGroupWriterImpl)groupWriter).setLastTimeMap(this.nonAlignedTimeseriesLastTimeMap.getOrDefault(deviceId, new HashMap()));
                }
            }
            this.groupWriters.put(deviceId, groupWriter);
        } else {
            groupWriter = this.groupWriters.get(deviceId);
        }
        return groupWriter;
    }

    public boolean write(TSRecord record) throws IOException, WriteProcessException {
        this.checkIsTimeseriesExist(record, false);
        this.recordCount += (long)this.groupWriters.get(new PlainDeviceID(record.deviceId)).write(record.time, record.dataPointList);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    public boolean writeAligned(TSRecord record) throws IOException, WriteProcessException {
        this.checkIsTimeseriesExist(record, true);
        this.recordCount += (long)this.groupWriters.get(new PlainDeviceID(record.deviceId)).write(record.time, record.dataPointList);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    public boolean write(Tablet tablet) throws IOException, WriteProcessException {
        this.checkIsTimeseriesExist(tablet, false);
        this.recordCount += (long)this.groupWriters.get(new PlainDeviceID(tablet.deviceId)).write(tablet);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    public boolean writeAligned(Tablet tablet) throws IOException, WriteProcessException {
        this.checkIsTimeseriesExist(tablet, true);
        this.recordCount += (long)this.groupWriters.get(new PlainDeviceID(tablet.deviceId)).write(tablet);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    private long calculateMemSizeForAllGroup() {
        long memTotalSize = 0L;
        for (IChunkGroupWriter group : this.groupWriters.values()) {
            memTotalSize += group.updateMaxGroupMemSize();
        }
        return memTotalSize;
    }

    private boolean checkMemorySizeAndMayFlushChunks() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.calculateMemSizeForAllGroup();
            assert (memSize > 0L);
            if (memSize > this.chunkGroupSizeThreshold) {
                LOG.debug("start to flush chunk groups, memory space occupy:{}", (Object)memSize);
                this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
                return this.flushAllChunkGroups();
            }
            this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
            return false;
        }
        return false;
    }

    public boolean flushAllChunkGroups() throws IOException {
        if (this.recordCount > 0L) {
            for (Map.Entry<IDeviceID, IChunkGroupWriter> entry : this.groupWriters.entrySet()) {
                IDeviceID deviceId = entry.getKey();
                IChunkGroupWriter groupWriter = entry.getValue();
                this.fileWriter.startChunkGroup(deviceId);
                long pos = this.fileWriter.getPos();
                long dataSize = groupWriter.flushToFileWriter(this.fileWriter);
                if (this.fileWriter.getPos() - pos != dataSize) {
                    throw new IOException(String.format("Flushed data size is inconsistent with computation! Estimated: %d, Actual: %d", dataSize, this.fileWriter.getPos() - pos));
                }
                this.fileWriter.endChunkGroup();
                if (groupWriter instanceof AlignedChunkGroupWriterImpl) {
                    List measurementList = this.flushedMeasurementsInDeviceMap.computeIfAbsent(deviceId, p -> new ArrayList());
                    ((AlignedChunkGroupWriterImpl)groupWriter).getMeasurements().forEach(measurementId -> {
                        if (!measurementList.contains(measurementId)) {
                            measurementList.add(measurementId);
                        }
                    });
                    if (this.isUnseq) continue;
                    this.alignedDeviceLastTimeMap.put(deviceId, ((AlignedChunkGroupWriterImpl)groupWriter).getLastTime());
                    continue;
                }
                if (this.isUnseq) continue;
                this.nonAlignedTimeseriesLastTimeMap.put(deviceId, ((NonAlignedChunkGroupWriterImpl)groupWriter).getLastTimeMap());
            }
            this.reset();
        }
        return false;
    }

    private void reset() {
        this.groupWriters.clear();
        this.recordCount = 0L;
    }

    @Override
    public void close() throws IOException {
        LOG.info("start close file");
        this.flushAllChunkGroups();
        this.fileWriter.endFile();
    }

    public TsFileIOWriter getIOWriter() {
        return this.fileWriter;
    }
}

