/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.enums.PipeRemainingTimeRateAverageTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfig.class);

    public int getPipeNonForwardingEventsProgressReportInterval() {
        return COMMON_CONFIG.getPipeNonForwardingEventsProgressReportInterval();
    }

    public String getPipeHardlinkBaseDirName() {
        return COMMON_CONFIG.getPipeHardlinkBaseDirName();
    }

    public String getPipeHardlinkTsFileDirName() {
        return COMMON_CONFIG.getPipeHardlinkTsFileDirName();
    }

    public String getPipeHardlinkWALDirName() {
        return COMMON_CONFIG.getPipeHardlinkWALDirName();
    }

    public boolean getPipeHardLinkWALEnabled() {
        return COMMON_CONFIG.getPipeHardLinkWALEnabled();
    }

    public int getPipeDataStructureTabletRowSize() {
        return COMMON_CONFIG.getPipeDataStructureTabletRowSize();
    }

    public int getPipeDataStructureTabletSizeInBytes() {
        return COMMON_CONFIG.getPipeDataStructureTabletSizeInBytes();
    }

    public double getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold() {
        return COMMON_CONFIG.getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold();
    }

    public int getPipeRealTimeQueuePollHistoryThreshold() {
        return COMMON_CONFIG.getPipeRealTimeQueuePollHistoryThreshold();
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getPipeSubtaskExecutorMaxThreadNum();
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount();
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration();
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return COMMON_CONFIG.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    public long getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() {
        return COMMON_CONFIG.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    }

    public long getPipeSubtaskExecutorForcedRestartIntervalMs() {
        return COMMON_CONFIG.getPipeSubtaskExecutorForcedRestartIntervalMs();
    }

    public int getPipeExtractorAssignerDisruptorRingBufferSize() {
        return COMMON_CONFIG.getPipeExtractorAssignerDisruptorRingBufferSize();
    }

    public long getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes() {
        return COMMON_CONFIG.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes();
    }

    public int getPipeExtractorMatcherCacheSize() {
        return COMMON_CONFIG.getPipeExtractorMatcherCacheSize();
    }

    public int getPipeConnectorHandshakeTimeoutMs() {
        return COMMON_CONFIG.getPipeConnectorHandshakeTimeoutMs();
    }

    public int getPipeConnectorTransferTimeoutMs() {
        return COMMON_CONFIG.getPipeConnectorTransferTimeoutMs();
    }

    public int getPipeConnectorReadFileBufferSize() {
        return COMMON_CONFIG.getPipeConnectorReadFileBufferSize();
    }

    public long getPipeConnectorRetryIntervalMs() {
        return COMMON_CONFIG.getPipeConnectorRetryIntervalMs();
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return COMMON_CONFIG.isPipeConnectorRPCThriftCompressionEnabled();
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorSelectorNumber();
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorMaxClientNumber();
    }

    public double getPipeAllConnectorsRateLimitBytesPerSecond() {
        return COMMON_CONFIG.getPipeAllSinksRateLimitBytesPerSecond();
    }

    public int getRateLimiterHotReloadCheckIntervalMs() {
        return COMMON_CONFIG.getRateLimiterHotReloadCheckIntervalMs();
    }

    public int getPipeConnectorRequestSliceThresholdBytes() {
        return COMMON_CONFIG.getPipeConnectorRequestSliceThresholdBytes();
    }

    public float getPipeLeaderCacheMemoryUsagePercentage() {
        return COMMON_CONFIG.getPipeLeaderCacheMemoryUsagePercentage();
    }

    public long getPipeListeningQueueTransferSnapshotThreshold() {
        return COMMON_CONFIG.getPipeListeningQueueTransferSnapshotThreshold();
    }

    public int getPipeSnapshotExecutionMaxBatchSize() {
        return COMMON_CONFIG.getPipeSnapshotExecutionMaxBatchSize();
    }

    public long getPipeRemainingTimeCommitAutoSwitchSeconds() {
        return COMMON_CONFIG.getPipeRemainingTimeCommitRateAutoSwitchSeconds();
    }

    public PipeRemainingTimeRateAverageTime getPipeRemainingTimeCommitRateAverageTime() {
        return COMMON_CONFIG.getPipeRemainingTimeCommitRateAverageTime();
    }

    public double getPipeTsFileScanParsingThreshold() {
        return COMMON_CONFIG.getPipeTsFileScanParsingThreshold();
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return COMMON_CONFIG.isSeperatedPipeHeartbeatEnabled();
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return COMMON_CONFIG.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta();
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerInitialSyncDelayMinutes();
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerSyncIntervalMinutes();
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return COMMON_CONFIG.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound();
    }

    public boolean getPipeAutoRestartEnabled() {
        return COMMON_CONFIG.getPipeAutoRestartEnabled();
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return COMMON_CONFIG.getPipeAirGapReceiverEnabled();
    }

    public int getPipeAirGapReceiverPort() {
        return COMMON_CONFIG.getPipeAirGapReceiverPort();
    }

    public int getPipeMaxAllowedHistoricalTsFilePerDataRegion() {
        return COMMON_CONFIG.getPipeMaxAllowedHistoricalTsFilePerDataRegion();
    }

    public int getPipeMaxAllowedPendingTsFileEpochPerDataRegion() {
        return COMMON_CONFIG.getPipeMaxAllowedPendingTsFileEpochPerDataRegion();
    }

    public int getPipeMaxAllowedPinnedMemTableCount() {
        return COMMON_CONFIG.getPipeMaxAllowedPinnedMemTableCount();
    }

    public long getPipeMaxAllowedLinkedTsFileCount() {
        return COMMON_CONFIG.getPipeMaxAllowedLinkedTsFileCount();
    }

    public float getPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage() {
        return COMMON_CONFIG.getPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage();
    }

    public long getPipeStuckRestartIntervalSeconds() {
        return COMMON_CONFIG.getPipeStuckRestartIntervalSeconds();
    }

    public int getPipeMetaReportMaxLogNumPerRound() {
        return COMMON_CONFIG.getPipeMetaReportMaxLogNumPerRound();
    }

    public int getPipeMetaReportMaxLogIntervalRounds() {
        return COMMON_CONFIG.getPipeMetaReportMaxLogIntervalRounds();
    }

    public int getPipeTsFilePinMaxLogNumPerRound() {
        return COMMON_CONFIG.getPipeTsFilePinMaxLogNumPerRound();
    }

    public int getPipeTsFilePinMaxLogIntervalRounds() {
        return COMMON_CONFIG.getPipeTsFilePinMaxLogIntervalRounds();
    }

    public int getPipeWalPinMaxLogNumPerRound() {
        return COMMON_CONFIG.getPipeWalPinMaxLogNumPerRound();
    }

    public int getPipeWalPinMaxLogIntervalRounds() {
        return COMMON_CONFIG.getPipeWalPinMaxLogIntervalRounds();
    }

    public boolean getPipeMemoryManagementEnabled() {
        return COMMON_CONFIG.getPipeMemoryManagementEnabled();
    }

    public int getPipeMemoryAllocateMaxRetries() {
        return COMMON_CONFIG.getPipeMemoryAllocateMaxRetries();
    }

    public long getPipeMemoryAllocateRetryIntervalInMs() {
        return COMMON_CONFIG.getPipeMemoryAllocateRetryIntervalInMs();
    }

    public long getPipeMemoryAllocateMinSizeInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateMinSizeInBytes();
    }

    public long getPipeMemoryAllocateForTsFileSequenceReaderInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
    }

    public long getPipeMemoryExpanderIntervalSeconds() {
        return COMMON_CONFIG.getPipeMemoryExpanderIntervalSeconds();
    }

    public long getTwoStageAggregateMaxCombinerLiveTimeInMs() {
        return COMMON_CONFIG.getTwoStageAggregateMaxCombinerLiveTimeInMs();
    }

    public long getTwoStageAggregateDataRegionInfoCacheTimeInMs() {
        return COMMON_CONFIG.getTwoStageAggregateDataRegionInfoCacheTimeInMs();
    }

    public long getTwoStageAggregateSenderEndPointsCacheInMs() {
        return COMMON_CONFIG.getTwoStageAggregateSenderEndPointsCacheInMs();
    }

    public float getSubscriptionCacheMemoryUsagePercentage() {
        return COMMON_CONFIG.getSubscriptionCacheMemoryUsagePercentage();
    }

    public void printAllConfigs() {
        LOGGER.info("PipeNonForwardingEventsProgressReportInterval: {}", (Object)this.getPipeNonForwardingEventsProgressReportInterval());
        LOGGER.info("PipeHardlinkBaseDirName: {}", (Object)this.getPipeHardlinkBaseDirName());
        LOGGER.info("PipeHardlinkTsFileDirName: {}", (Object)this.getPipeHardlinkTsFileDirName());
        LOGGER.info("PipeHardlinkWALDirName: {}", (Object)this.getPipeHardlinkWALDirName());
        LOGGER.info("PipeHardLinkWALEnabled: {}", (Object)this.getPipeHardLinkWALEnabled());
        LOGGER.info("PipeDataStructureTabletRowSize: {}", (Object)this.getPipeDataStructureTabletRowSize());
        LOGGER.info("PipeDataStructureTabletSizeInBytes: {}", (Object)this.getPipeDataStructureTabletSizeInBytes());
        LOGGER.info("PipeDataStructureTabletMemoryBlockAllocationRejectThreshold: {}", (Object)this.getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold());
        LOGGER.info("PipeRealTimeQueuePollHistoryThreshold: {}", (Object)this.getPipeRealTimeQueuePollHistoryThreshold());
        LOGGER.info("PipeSubtaskExecutorMaxThreadNum: {}", (Object)this.getPipeSubtaskExecutorMaxThreadNum());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration());
        LOGGER.info("PipeSubtaskExecutorPendingQueueMaxBlockingTimeMs: {}", (Object)this.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs());
        LOGGER.info("PipeSubtaskExecutorCronHeartbeatEventIntervalSeconds: {}", (Object)this.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds());
        LOGGER.info("PipeSubtaskExecutorForcedRestartIntervalMs: {}", (Object)this.getPipeSubtaskExecutorForcedRestartIntervalMs());
        LOGGER.info("PipeExtractorAssignerDisruptorRingBufferSize: {}", (Object)this.getPipeExtractorAssignerDisruptorRingBufferSize());
        LOGGER.info("PipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes: {}", (Object)this.getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes());
        LOGGER.info("PipeExtractorMatcherCacheSize: {}", (Object)this.getPipeExtractorMatcherCacheSize());
        LOGGER.info("PipeConnectorHandshakeTimeoutMs: {}", (Object)this.getPipeConnectorHandshakeTimeoutMs());
        LOGGER.info("PipeConnectorTransferTimeoutMs: {}", (Object)this.getPipeConnectorTransferTimeoutMs());
        LOGGER.info("PipeConnectorReadFileBufferSize: {}", (Object)this.getPipeConnectorReadFileBufferSize());
        LOGGER.info("PipeConnectorRetryIntervalMs: {}", (Object)this.getPipeConnectorRetryIntervalMs());
        LOGGER.info("PipeConnectorRPCThriftCompressionEnabled: {}", (Object)this.isPipeConnectorRPCThriftCompressionEnabled());
        LOGGER.info("PipeLeaderCacheMemoryUsagePercentage: {}", (Object)Float.valueOf(this.getPipeLeaderCacheMemoryUsagePercentage()));
        LOGGER.info("PipeListeningQueueTransferSnapshotThreshold: {}", (Object)this.getPipeListeningQueueTransferSnapshotThreshold());
        LOGGER.info("PipeSnapshotExecutionMaxBatchSize: {}", (Object)this.getPipeSnapshotExecutionMaxBatchSize());
        LOGGER.info("PipeRemainingTimeCommitAutoSwitchSeconds: {}", (Object)this.getPipeRemainingTimeCommitAutoSwitchSeconds());
        LOGGER.info("PipeRemainingTimeCommitRateAverageTime: {}", (Object)this.getPipeRemainingTimeCommitRateAverageTime());
        LOGGER.info("PipeTsFileScanParsingThreshold(): {}", (Object)this.getPipeTsFileScanParsingThreshold());
        LOGGER.info("PipeAsyncConnectorSelectorNumber: {}", (Object)this.getPipeAsyncConnectorSelectorNumber());
        LOGGER.info("PipeAsyncConnectorMaxClientNumber: {}", (Object)this.getPipeAsyncConnectorMaxClientNumber());
        LOGGER.info("PipeAllConnectorsRateLimitBytesPerSecond: {}", (Object)this.getPipeAllConnectorsRateLimitBytesPerSecond());
        LOGGER.info("RateLimiterHotReloadCheckIntervalMs: {}", (Object)this.getRateLimiterHotReloadCheckIntervalMs());
        LOGGER.info("PipeConnectorRequestSliceThresholdBytes: {}", (Object)this.getPipeConnectorRequestSliceThresholdBytes());
        LOGGER.info("SeperatedPipeHeartbeatEnabled: {}", (Object)this.isSeperatedPipeHeartbeatEnabled());
        LOGGER.info("PipeHeartbeatIntervalSecondsForCollectingPipeMeta: {}", (Object)this.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta());
        LOGGER.info("PipeMetaSyncerInitialSyncDelayMinutes: {}", (Object)this.getPipeMetaSyncerInitialSyncDelayMinutes());
        LOGGER.info("PipeMetaSyncerSyncIntervalMinutes: {}", (Object)this.getPipeMetaSyncerSyncIntervalMinutes());
        LOGGER.info("PipeMetaSyncerAutoRestartPipeCheckIntervalRound: {}", (Object)this.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound());
        LOGGER.info("PipeAutoRestartEnabled: {}", (Object)this.getPipeAutoRestartEnabled());
        LOGGER.info("PipeAirGapReceiverEnabled: {}", (Object)this.getPipeAirGapReceiverEnabled());
        LOGGER.info("PipeAirGapReceiverPort: {}", (Object)this.getPipeAirGapReceiverPort());
        LOGGER.info("PipeMaxAllowedHistoricalTsFilePerDataRegion: {}", (Object)this.getPipeMaxAllowedHistoricalTsFilePerDataRegion());
        LOGGER.info("PipeMaxAllowedPendingTsFileEpochPerDataRegion: {}", (Object)this.getPipeMaxAllowedPendingTsFileEpochPerDataRegion());
        LOGGER.info("PipeMaxAllowedPinnedMemTableCount: {}", (Object)this.getPipeMaxAllowedPinnedMemTableCount());
        LOGGER.info("PipeMaxAllowedLinkedTsFileCount: {}", (Object)this.getPipeMaxAllowedLinkedTsFileCount());
        LOGGER.info("PipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage: {}", (Object)Float.valueOf(this.getPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage()));
        LOGGER.info("PipeStuckRestartIntervalSeconds: {}", (Object)this.getPipeStuckRestartIntervalSeconds());
        LOGGER.info("PipeMetaReportMaxLogNumPerRound: {}", (Object)this.getPipeMetaReportMaxLogNumPerRound());
        LOGGER.info("PipeMetaReportMaxLogIntervalRounds: {}", (Object)this.getPipeMetaReportMaxLogIntervalRounds());
        LOGGER.info("PipeTsFilePinMaxLogNumPerRound: {}", (Object)this.getPipeTsFilePinMaxLogNumPerRound());
        LOGGER.info("PipeTsFilePinMaxLogIntervalRounds: {}", (Object)this.getPipeTsFilePinMaxLogIntervalRounds());
        LOGGER.info("PipeWalPinMaxLogNumPerRound: {}", (Object)this.getPipeWalPinMaxLogNumPerRound());
        LOGGER.info("PipeWalPinMaxLogIntervalRounds: {}", (Object)this.getPipeWalPinMaxLogIntervalRounds());
        LOGGER.info("PipeMemoryManagementEnabled: {}", (Object)this.getPipeMemoryManagementEnabled());
        LOGGER.info("PipeMemoryAllocateMaxRetries: {}", (Object)this.getPipeMemoryAllocateMaxRetries());
        LOGGER.info("PipeMemoryAllocateRetryIntervalInMs: {}", (Object)this.getPipeMemoryAllocateRetryIntervalInMs());
        LOGGER.info("PipeMemoryAllocateMinSizeInBytes: {}", (Object)this.getPipeMemoryAllocateMinSizeInBytes());
        LOGGER.info("PipeMemoryAllocateForTsFileSequenceReaderInBytes: {}", (Object)this.getPipeMemoryAllocateForTsFileSequenceReaderInBytes());
        LOGGER.info("PipeMemoryExpanderIntervalSeconds: {}", (Object)this.getPipeMemoryExpanderIntervalSeconds());
        LOGGER.info("TwoStageAggregateMaxCombinerLiveTimeInMs: {}", (Object)this.getTwoStageAggregateMaxCombinerLiveTimeInMs());
        LOGGER.info("TwoStageAggregateDataRegionInfoCacheTimeInMs: {}", (Object)this.getTwoStageAggregateDataRegionInfoCacheTimeInMs());
        LOGGER.info("TwoStageAggregateSenderEndPointsCacheInMs: {}", (Object)this.getTwoStageAggregateSenderEndPointsCacheInMs());
        LOGGER.info("SubscriptionCacheMemoryUsagePercentage: {}", (Object)Float.valueOf(this.getSubscriptionCacheMemoryUsagePercentage()));
    }

    private PipeConfig() {
    }

    public static PipeConfig getInstance() {
        return PipeConfigHolder.INSTANCE;
    }

    private static class PipeConfigHolder {
        private static final PipeConfig INSTANCE = new PipeConfig();

        private PipeConfigHolder() {
        }
    }
}

