/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemPropertiesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesHandler.class);
    private File formalFile;
    private File tmpFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();

    public SystemPropertiesHandler(String filePath) {
        this.formalFile = SystemFileFactory.INSTANCE.getFile(filePath);
        this.tmpFile = SystemFileFactory.INSTANCE.getFile(filePath + ".tmp");
    }

    public void put(Object ... keyOrValue) throws IOException {
        if (keyOrValue.length % 2 != 0) {
            throw new IllegalArgumentException("Length of parameters should be evenly divided by 2, but the actual length is " + keyOrValue.length + " : " + Arrays.toString(keyOrValue));
        }
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.writeLock());){
            Properties properties = this.readWithoutLock(this.formalFile);
            for (int i = 0; i < keyOrValue.length; i += 2) {
                properties.put(keyOrValue[i], keyOrValue[i + 1]);
            }
            this.writeWithoutLock(properties, this.tmpFile);
            this.replaceFormalFile();
        }
    }

    public void overwrite(Properties properties) throws IOException {
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.writeLock());){
            if (!this.formalFile.exists()) {
                this.writeWithoutLock(properties, this.formalFile);
                return;
            }
            this.writeWithoutLock(properties, this.tmpFile);
            this.replaceFormalFile();
        }
    }

    public Properties read() throws IOException {
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.readLock());){
            Properties properties = this.readWithoutLock(this.formalFile);
            return properties;
        }
    }

    public void remove(String key) throws IOException {
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.writeLock());){
            Properties properties = this.readWithoutLock(this.formalFile);
            if (!properties.containsKey(key)) {
                return;
            }
            properties.remove(key);
            this.writeWithoutLock(properties, this.tmpFile);
            this.replaceFormalFile();
        }
    }

    private void writeWithoutLock(Properties properties, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            properties.store(writer, "");
            fileOutputStream.getFD().sync();
        }
    }

    private Properties readWithoutLock(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            try (FileInputStream inputStream = new FileInputStream(this.formalFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                properties.load(reader);
            }
        }
        return properties;
    }

    public boolean fileExist() {
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.readLock());){
            boolean bl = this.formalFile.exists() || this.tmpFile.exists();
            return bl;
        }
    }

    public boolean isFirstStart() {
        return !this.fileExist();
    }

    protected void init() {
        try (AutoCloseableLock ignore = AutoCloseableLock.acquire((Lock)this.lock.writeLock());){
            this.recover();
            this.remove("cluster_name");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void recover() throws IOException {
        if (this.formalFile.exists() && !this.tmpFile.exists()) {
            return;
        }
        if (!this.formalFile.exists() && !this.tmpFile.exists()) {
            return;
        }
        if (this.formalFile.exists() && this.tmpFile.exists()) {
            if (!this.tmpFile.delete()) {
                LOGGER.warn("Delete system.properties tmp file fail, you may manually delete it: {}", (Object)this.tmpFile.getAbsoluteFile());
            }
            return;
        }
        if (!this.formalFile.exists() && this.tmpFile.exists()) {
            this.replaceFormalFile();
            return;
        }
        throw new UnsupportedOperationException("Should never touch here");
    }

    private void replaceFormalFile() throws IOException {
        if (!this.tmpFile.exists()) {
            throw new FileNotFoundException("Tmp system properties file must exist when call replaceFormalFile");
        }
        if (this.formalFile.exists() && !this.formalFile.delete()) {
            String msg = String.format("Delete formal system properties file fail: %s", this.formalFile.getAbsoluteFile());
            throw new IOException(msg);
        }
        try {
            FileUtils.move((Path)this.tmpFile.toPath(), (Path)this.formalFile.toPath(), (CopyOption[])new CopyOption[0]);
        }
        catch (IOException e) {
            String msg = String.format("Failed to replace formal system properties file, you may manually rename it: %s -> %s", this.tmpFile.getAbsolutePath(), this.formalFile.getAbsolutePath());
            throw new IOException(msg, e);
        }
    }

    public void resetFilePath(String filePath) {
        this.formalFile = SystemFileFactory.INSTANCE.getFile(filePath);
        this.tmpFile = SystemFileFactory.INSTANCE.getFile(filePath + ".tmp");
    }
}

