/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.commons.exception.IoTDBException;

public abstract class ServerCommandLine {
    private static final Option OPTION_START = Option.builder((String)"s").longOpt("start").desc("start a new node").build();
    private static final Option OPTION_REMOVE = Option.builder((String)"r").longOpt("remove").desc("remove a node (with the given nodeId or the node started on the current machine, if omitted)").hasArg().type(Number.class).argName("nodeId").optionalArg(true).build();
    private final String cliName;
    private final PrintWriter output;
    private final Options options;

    public ServerCommandLine(String cliName) {
        this(cliName, new PrintWriter(System.out));
    }

    public ServerCommandLine(String cliName, PrintWriter output) {
        this.cliName = cliName;
        this.output = output;
        OptionGroup commands = new OptionGroup();
        commands.addOption(OPTION_START);
        commands.addOption(OPTION_REMOVE);
        commands.setRequired(true);
        this.options = new Options();
        this.options.addOptionGroup(commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            if (cmd.hasOption(OPTION_START)) {
                this.start();
            } else {
                Number nodeId = (Number)cmd.getParsedOptionValue(OPTION_REMOVE);
                if (nodeId != null) {
                    this.remove(nodeId.longValue());
                } else {
                    this.remove(null);
                }
            }
            int nodeId = 0;
            return nodeId;
        }
        catch (ParseException e) {
            this.output.println(e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.output, formatter.getWidth(), this.cliName, null, this.options, formatter.getLeftPadding(), formatter.getDescPadding(), null, false);
            int n = 1;
            return n;
        }
        catch (IoTDBException e) {
            this.output.println("An error occurred while running the command: " + e.getMessage());
            int n = e.getErrorCode();
            return n;
        }
        finally {
            this.output.flush();
        }
    }

    protected abstract void start() throws IoTDBException;

    protected abstract void remove(Long var1) throws IoTDBException;
}

