/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.AbstractSessionMessageQueue;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.broker.unsafequeues.Queue;
import io.moquette.broker.unsafequeues.QueueException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class SegmentPersistentQueue
extends AbstractSessionMessageQueue<SessionRegistry.EnqueuedMessage> {
    private final Queue segmentedQueue;
    private final SerDes serdes = new SerDes();

    public SegmentPersistentQueue(Queue segmentedQueue) {
        this.segmentedQueue = segmentedQueue;
    }

    @Override
    public void enqueue(SessionRegistry.EnqueuedMessage message) {
        this.checkEnqueuePreconditions(message);
        ByteBuffer payload = this.serdes.toBytes(message);
        try {
            this.segmentedQueue.enqueue(payload);
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SessionRegistry.EnqueuedMessage dequeue() {
        Optional<ByteBuffer> dequeue;
        this.checkDequeuePreconditions();
        try {
            dequeue = this.segmentedQueue.dequeue();
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
        if (!dequeue.isPresent()) {
            return null;
        }
        ByteBuffer content = dequeue.get();
        return this.serdes.fromBytes(content);
    }

    @Override
    public boolean isEmpty() {
        return this.segmentedQueue.isEmpty();
    }

    @Override
    public void closeAndPurge() {
        this.closed = true;
    }

    private static class SerDes {
        private SerDes() {
        }

        public ByteBuffer toBytes(SessionRegistry.EnqueuedMessage message) {
            int memorySize = this.getMemory(message);
            ByteBuffer payload = ByteBuffer.allocate(memorySize);
            payload.mark();
            this.write(message, payload);
            payload.reset();
            return payload;
        }

        private void write(SessionRegistry.EnqueuedMessage obj, ByteBuffer buff) {
            if (obj instanceof SessionRegistry.PublishedMessage) {
                buff.put((byte)MessageType.PUBLISHED_MESSAGE.ordinal());
                SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
                buff.put((byte)casted.getPublishingQos().value());
                String topic = casted.getTopic().toString();
                this.writeTopic(buff, topic);
                this.writePayload(buff, casted.getPayload());
            } else if (obj instanceof SessionRegistry.PubRelMarker) {
                buff.put((byte)MessageType.PUB_REL_MARKER.ordinal());
            } else {
                throw new IllegalArgumentException("Unrecognized message class " + obj.getClass());
            }
        }

        private void writePayload(ByteBuffer target, ByteBuf source) {
            int payloadSize = source.readableBytes();
            byte[] rawBytes = new byte[payloadSize];
            int pinPoint = source.readerIndex();
            source.readBytes(rawBytes).release();
            source.readerIndex(pinPoint);
            target.putInt(payloadSize);
            target.put(rawBytes);
        }

        private void writeTopic(ByteBuffer buff, String topic) {
            byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            buff.putInt(topicBytes.length).put(topicBytes);
        }

        private int getMemory(SessionRegistry.EnqueuedMessage obj) {
            if (obj instanceof SessionRegistry.PubRelMarker) {
                return 1;
            }
            SessionRegistry.PublishedMessage casted = (SessionRegistry.PublishedMessage)obj;
            return 2 + this.topicMemorySize(casted.getTopic()) + this.payloadMemorySize(casted.getPayload());
        }

        private int payloadMemorySize(ByteBuf payload) {
            return 4 + payload.readableBytes();
        }

        private int topicMemorySize(Topic topic) {
            return 4 + topic.toString().getBytes(StandardCharsets.UTF_8).length;
        }

        public SessionRegistry.EnqueuedMessage fromBytes(ByteBuffer buff) {
            byte messageType = buff.get();
            if (messageType == MessageType.PUB_REL_MARKER.ordinal()) {
                return new SessionRegistry.PubRelMarker();
            }
            if (messageType == MessageType.PUBLISHED_MESSAGE.ordinal()) {
                MqttQoS qos = MqttQoS.valueOf((int)buff.get());
                String topicStr = this.readTopic(buff);
                ByteBuf payload = this.readPayload(buff);
                return new SessionRegistry.PublishedMessage(Topic.asTopic(topicStr), qos, payload, false);
            }
            throw new IllegalArgumentException("Can't recognize record of type: " + messageType);
        }

        private String readTopic(ByteBuffer buff) {
            int stringLen = buff.getInt();
            byte[] rawString = new byte[stringLen];
            buff.get(rawString);
            return new String(rawString, StandardCharsets.UTF_8);
        }

        private ByteBuf readPayload(ByteBuffer buff) {
            int payloadSize = buff.getInt();
            byte[] payload = new byte[payloadSize];
            buff.get(payload);
            return Unpooled.wrappedBuffer((byte[])payload);
        }

        private static enum MessageType {
            PUB_REL_MARKER,
            PUBLISHED_MESSAGE;

        }
    }
}

