/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.BackwardSort;
import org.apache.iotdb.db.utils.datastructure.QuickLongTVList;
import org.apache.tsfile.enums.TSDataType;

public class BackLongTVList
extends QuickLongTVList
implements BackwardSort {
    private final List<long[]> tmpTimestamps = new ArrayList<long[]>();
    private final List<long[]> tmpValues = new ArrayList<long[]>();
    private int tmpLength = 0;

    @Override
    public void sort() {
        if (!this.sorted) {
            this.backwardSort(this.timestamps, this.rowCount);
            this.clearTmp();
        }
        this.sorted = true;
    }

    @Override
    public void setFromTmp(int src, int dest) {
        this.set(dest, this.tmpTimestamps.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE], this.tmpValues.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    public void setToTmp(int src, int dest) {
        this.tmpTimestamps.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.tmpValues.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getLong(src);
    }

    @Override
    public void backward_set(int src, int dest) {
        this.set(src, dest);
    }

    @Override
    public int compareTmp(int idx, int tmpIdx) {
        long t1 = this.getTime(idx);
        long t2 = this.tmpTimestamps.get(tmpIdx / PrimitiveArrayManager.ARRAY_SIZE)[tmpIdx % PrimitiveArrayManager.ARRAY_SIZE];
        return Long.compare(t1, t2);
    }

    @Override
    public void checkTmpLength(int len) {
        while (len > this.tmpLength) {
            this.tmpTimestamps.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
            this.tmpValues.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
            this.tmpLength += PrimitiveArrayManager.ARRAY_SIZE;
        }
    }

    @Override
    public void clearTmp() {
        for (long[] dataArray : this.tmpTimestamps) {
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpTimestamps.clear();
        for (long[] dataArray : this.tmpValues) {
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpValues.clear();
    }
}

