/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.subtask;

import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConnectorSubtask
extends PipeConnectorSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConnectorSubtask.class);
    private final String topicName;
    private final String consumerGroupId;

    public SubscriptionConnectorSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, UnboundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector, String topicName, String consumerGroupId) {
        super(taskID, creationTime, attributeSortedString, connectorIndex, inputPendingQueue, outputPipeConnector);
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
    }

    @Override
    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        SubscriptionAgent.broker().executePrefetch(this.consumerGroupId, this.topicName);
        return true;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public UnboundedBlockingPendingQueue<Event> getInputPendingQueue() {
        return this.inputPendingQueue;
    }

    @Override
    public int getEventCount(String pipeName) {
        return SubscriptionAgent.broker().getPipeEventCount(this.consumerGroupId, this.topicName);
    }
}

