/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.metric.PipeWALInsertNodeCacheMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALByteBufReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;
import org.apache.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALInsertNodeCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(WALInsertNodeCache.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final AtomicDouble memoryUsageCheatFactor = new AtomicDouble(1.0);
    private final AtomicBoolean isBatchLoadEnabled = new AtomicBoolean(true);
    private final LoadingCache<WALEntryPosition, Pair<ByteBuffer, InsertNode>> lruCache;
    private final Set<Long> memTablesNeedSearch = ConcurrentHashMap.newKeySet();
    private volatile boolean hasPipeRunning = false;

    private WALInsertNodeCache(Integer dataRegionId) {
        long requestedAllocateSize = (long)Math.min(2.0 * (double)CONFIG.getWalFileSizeThresholdInByte(), (double)CONFIG.getAllocateMemoryForPipe() * 0.8 / 5.0);
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(requestedAllocateSize).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestedAllocateSize)).setExpandCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor / ((double)newMemory.longValue() / (double)oldMemory.longValue()));
            this.isBatchLoadEnabled.set(newMemory >= CONFIG.getWalFileSizeThresholdInByte());
            LOGGER.info("WALInsertNodeCache.allocatedMemoryBlock of dataRegion {} has expanded from {} to {}.", new Object[]{dataRegionId, oldMemory, newMemory});
        });
        this.isBatchLoadEnabled.set(this.allocatedMemoryBlock.getMemoryUsageInBytes() >= CONFIG.getWalFileSizeThresholdInByte());
        this.lruCache = Caffeine.newBuilder().maximumWeight(this.allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((position, pair) -> {
            long weightInLong = 0L;
            weightInLong = pair.right != null ? (long)((double)InsertNodeMemoryEstimator.sizeOf((InsertNode)pair.right) * this.memoryUsageCheatFactor.get()) : (long)((double)position.getSize() * this.memoryUsageCheatFactor.get());
            if (weightInLong <= 0L) {
                return Integer.MAX_VALUE;
            }
            int weightInInt = (int)weightInLong;
            return (long)weightInInt != weightInLong ? Integer.MAX_VALUE : weightInInt;
        }).recordStats().build((CacheLoader)new WALInsertNodeCacheLoader());
        this.allocatedMemoryBlock.setShrinkCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor * ((double)oldMemory.longValue() / (double)newMemory.longValue()));
            this.isBatchLoadEnabled.set(newMemory >= CONFIG.getWalFileSizeThresholdInByte());
            LOGGER.info("WALInsertNodeCache.allocatedMemoryBlock of dataRegion {} has shrunk from {} to {}.", new Object[]{dataRegionId, oldMemory, newMemory});
            if (CONFIG.getWALCacheShrinkClearEnabled()) {
                try {
                    this.lruCache.cleanUp();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to clear WALInsertNodeCache for dataRegion ID: {}.", (Object)dataRegionId, (Object)e);
                    return;
                }
                LOGGER.info("Successfully cleared WALInsertNodeCache for dataRegion ID: {}.", (Object)dataRegionId);
            }
        });
        PipeWALInsertNodeCacheMetrics.getInstance().register(this, dataRegionId);
    }

    public InsertNode getInsertNode(WALEntryPosition position) {
        Pair<ByteBuffer, InsertNode> pair = this.getByteBufferOrInsertNode(position);
        if (pair.getRight() != null) {
            return (InsertNode)pair.getRight();
        }
        if (pair.getLeft() == null) {
            throw new IllegalStateException();
        }
        try {
            InsertNode insertNode = this.parse(ByteBuffer.wrap(((ByteBuffer)pair.getLeft()).array()));
            pair.setRight((Object)insertNode);
            return insertNode;
        }
        catch (Exception e) {
            LOGGER.error("Parsing failed when recovering insertNode from wal, walFile:{}, position:{}, size:{}, exception:", new Object[]{position.getWalFile(), position.getPosition(), position.getSize(), e});
            throw e;
        }
    }

    private InsertNode parse(ByteBuffer buffer) {
        PlanNode node = WALEntry.deserializeForConsensus(buffer);
        if (node instanceof InsertNode) {
            return (InsertNode)node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer(WALEntryPosition position) {
        Pair<ByteBuffer, InsertNode> pair = this.getByteBufferOrInsertNode(position);
        if (pair.getLeft() != null) {
            return ByteBuffer.wrap(((ByteBuffer)pair.getLeft()).array());
        }
        WALInsertNodeCache wALInsertNodeCache = this;
        synchronized (wALInsertNodeCache) {
            this.lruCache.invalidate((Object)position);
            pair = this.getByteBufferOrInsertNode(position);
        }
        if (pair.getLeft() == null) {
            throw new IllegalStateException();
        }
        return ByteBuffer.wrap(((ByteBuffer)pair.getLeft()).array());
    }

    public Pair<ByteBuffer, InsertNode> getByteBufferOrInsertNode(WALEntryPosition position) {
        Pair pair;
        this.hasPipeRunning = true;
        Pair pair2 = pair = this.isBatchLoadEnabled.get() ? (Pair)this.lruCache.getAll(Collections.singleton(position)).get(position) : (Pair)this.lruCache.get((Object)position);
        if (pair == null) {
            throw new IllegalStateException();
        }
        return pair;
    }

    public void cacheInsertNodeIfNeeded(WALEntryPosition walEntryPosition, InsertNode insertNode) {
        if (this.hasPipeRunning) {
            this.lruCache.put((Object)walEntryPosition, (Object)new Pair(null, (Object)insertNode));
        }
    }

    public double getCacheHitRate() {
        return Objects.nonNull(this.lruCache) ? this.lruCache.stats().hitRate() : 0.0;
    }

    public double getCacheHitCount() {
        return Objects.nonNull(this.lruCache) ? (double)this.lruCache.stats().hitCount() : 0.0;
    }

    public double getCacheRequestCount() {
        return Objects.nonNull(this.lruCache) ? (double)this.lruCache.stats().requestCount() : 0.0;
    }

    public void addMemTable(long memTableId) {
        this.memTablesNeedSearch.add(memTableId);
    }

    public void removeMemTable(long memTableId) {
        this.memTablesNeedSearch.remove(memTableId);
    }

    public static WALInsertNodeCache getInstance(Integer regionId) {
        return InstanceHolder.getOrCreateInstance(regionId);
    }

    public boolean isBatchLoadEnabled() {
        return this.isBatchLoadEnabled.get();
    }

    public void setIsBatchLoadEnabled(boolean isBatchLoadEnabled) {
        this.isBatchLoadEnabled.set(isBatchLoadEnabled);
    }

    boolean contains(WALEntryPosition position) {
        return this.lruCache.getIfPresent((Object)position) != null;
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.allocatedMemoryBlock.close();
        this.memTablesNeedSearch.clear();
    }

    class WALInsertNodeCacheLoader
    implements CacheLoader<WALEntryPosition, Pair<ByteBuffer, InsertNode>> {
        WALInsertNodeCacheLoader() {
        }

        public @Nullable Pair<ByteBuffer, InsertNode> load(@NonNull WALEntryPosition key) throws Exception {
            return new Pair((Object)key.read(), null);
        }

        public @NonNull Map<@NonNull WALEntryPosition, @NonNull Pair<ByteBuffer, InsertNode>> loadAll(@NonNull Iterable<? extends @NonNull WALEntryPosition> walEntryPositions) {
            HashMap<WALEntryPosition, Pair<ByteBuffer, InsertNode>> loadedEntries = new HashMap<WALEntryPosition, Pair<ByteBuffer, InsertNode>>();
            for (WALEntryPosition wALEntryPosition : walEntryPositions) {
                if (loadedEntries.containsKey(wALEntryPosition) || !wALEntryPosition.canRead()) continue;
                long walFileVersionId = wALEntryPosition.getWalFileVersionId();
                if (!wALEntryPosition.isInSealedFile()) {
                    try {
                        loadedEntries.put(wALEntryPosition, this.load(wALEntryPosition));
                    }
                    catch (Exception e) {
                        LOGGER.info("Fail to cache wal entries from the wal file with version id {}", (Object)walFileVersionId, (Object)e);
                    }
                    continue;
                }
                long position = 0L;
                try (WALByteBufReader walByteBufReader = new WALByteBufReader(wALEntryPosition);){
                    while (walByteBufReader.hasNext()) {
                        ByteBuffer buffer = walByteBufReader.next();
                        int size = buffer.capacity();
                        WALEntryType type = WALEntryType.valueOf(buffer.get());
                        long memTableId = buffer.getLong();
                        if ((WALInsertNodeCache.this.memTablesNeedSearch.contains(memTableId) || wALEntryPosition.getPosition() == position) && type.needSearch()) {
                            buffer.clear();
                            loadedEntries.put(new WALEntryPosition(wALEntryPosition.getIdentifier(), walFileVersionId, position, size), (Pair<ByteBuffer, InsertNode>)new Pair((Object)buffer, null));
                        }
                        position += (long)size;
                    }
                }
                catch (IOException e) {
                    LOGGER.info("Fail to cache wal entries from the wal file with version id {}", (Object)walFileVersionId, (Object)e);
                }
            }
            return loadedEntries;
        }
    }

    private static class InstanceHolder {
        private static final Map<Integer, WALInsertNodeCache> INSTANCE_MAP = new ConcurrentHashMap<Integer, WALInsertNodeCache>();

        public static WALInsertNodeCache getOrCreateInstance(Integer key) {
            return INSTANCE_MAP.computeIfAbsent(key, k -> new WALInsertNodeCache(key));
        }

        private InstanceHolder() {
        }
    }
}

