/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.BatchDataFactory;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.utils.TsPrimitiveType;

public class MemAlignedPageReader
implements IPageReader {
    private final TsBlock tsBlock;
    private final AlignedChunkMetadata chunkMetadata;
    private Filter recordFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private TsBlockBuilder builder;

    public MemAlignedPageReader(TsBlock tsBlock, AlignedChunkMetadata chunkMetadata, Filter recordFilter) {
        this.tsBlock = tsBlock;
        this.chunkMetadata = chunkMetadata;
        this.recordFilter = recordFilter;
    }

    public BatchData getAllSatisfiedPageData() throws IOException {
        return super.getAllSatisfiedPageData();
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.VECTOR, (boolean)ascending, (boolean)false);
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        boolean[] hasValue = this.buildHasValueArray();
        for (int rowIndex = 0; rowIndex < this.tsBlock.getPositionCount(); ++rowIndex) {
            if (!satisfyInfo[rowIndex] || !hasValue[rowIndex]) continue;
            long time = this.tsBlock.getTimeByIndex(rowIndex);
            TsPrimitiveType[] values = new TsPrimitiveType[this.tsBlock.getValueColumnCount()];
            for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
                if (this.tsBlock.getColumn(column) == null || this.tsBlock.getColumn(column).isNull(rowIndex)) continue;
                values[column] = this.tsBlock.getColumn(column).getTsPrimitiveType(rowIndex);
            }
            batchData.putVector(time, values);
        }
        return batchData.flip();
    }

    public TsBlock getAllSatisfiedData() {
        this.builder.reset();
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        boolean[] hasValue = this.buildHasValueArray();
        int readEndIndex = this.buildTimeColumn(satisfyInfo, hasValue);
        this.buildValueColumns(satisfyInfo, hasValue, readEndIndex);
        return this.builder.build();
    }

    private boolean[] buildSatisfyInfoArray() {
        if (this.recordFilter == null || this.recordFilter.allSatisfy((IMetadata)this)) {
            boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
            Arrays.fill(satisfyInfo, true);
            return satisfyInfo;
        }
        return this.recordFilter.satisfyTsBlock(this.tsBlock);
    }

    private boolean[] buildHasValueArray() {
        boolean[] hasValue = new boolean[this.tsBlock.getPositionCount()];
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                hasValue[row] = hasValue[row] || !valueColumn.isNull(row);
            }
        }
        return hasValue;
    }

    private int buildTimeColumn(boolean[] satisfyInfo, boolean[] hasValue) {
        int readEndIndex = this.tsBlock.getPositionCount();
        for (int row = 0; row < readEndIndex; ++row) {
            if (this.needSkipCurrentRow(satisfyInfo, hasValue, row)) continue;
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(row));
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = row;
        }
        return readEndIndex;
    }

    private boolean needSkipCurrentRow(boolean[] satisfyInfo, boolean[] hasValue, int rowIndex) {
        if (!satisfyInfo[rowIndex] || !hasValue[rowIndex]) {
            return true;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            satisfyInfo[rowIndex] = false;
            return true;
        }
        return false;
    }

    private void buildValueColumns(boolean[] satisfyInfo, boolean[] hasValue, int readEndIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = this.builder.getColumnBuilder(column);
            for (int row = 0; row < readEndIndex; ++row) {
                if (!satisfyInfo[row] || !hasValue[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.chunkMetadata.getTimeStatistics();
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        return this.chunkMetadata.getMeasurementStatistics(measurementIndex);
    }

    public boolean hasNullValue(int measurementIndex) {
        return this.chunkMetadata.hasNullValue(measurementIndex);
    }

    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and((Filter)this.recordFilter, (Filter)filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }
}

