/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator;

import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.ICompactionTaskComparator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class DefaultCompactionTaskComparatorImpl
implements ICompactionTaskComparator {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public int compare(AbstractCompactionTask o1, AbstractCompactionTask o2) {
        if (o1 instanceof InsertionCrossSpaceCompactionTask && o2 instanceof InsertionCrossSpaceCompactionTask) {
            return o1.getSerialId() < o2.getSerialId() ? -1 : 1;
        }
        if (o1 instanceof InsertionCrossSpaceCompactionTask) {
            return -1;
        }
        if (o2 instanceof InsertionCrossSpaceCompactionTask) {
            return 1;
        }
        if (o1 instanceof SettleCompactionTask && o2 instanceof SettleCompactionTask) {
            return this.compareSettleCompactionTask((SettleCompactionTask)o1, (SettleCompactionTask)o2);
        }
        if (o1 instanceof SettleCompactionTask) {
            return -1;
        }
        if (o2 instanceof SettleCompactionTask) {
            return 1;
        }
        if (o1 instanceof InnerSpaceCompactionTask && o2 instanceof CrossSpaceCompactionTask || o2 instanceof InnerSpaceCompactionTask && o1 instanceof CrossSpaceCompactionTask) {
            if (this.config.getCompactionPriority() == CompactionPriority.CROSS_INNER) {
                return o1 instanceof CrossSpaceCompactionTask ? -1 : 1;
            }
            if (this.config.getCompactionPriority() == CompactionPriority.INNER_CROSS) {
                return o1 instanceof InnerSpaceCompactionTask ? -1 : 1;
            }
            if (o1.getSerialId() != o2.getSerialId()) {
                return o1.getSerialId() < o2.getSerialId() ? -1 : 1;
            }
            return o1 instanceof CrossSpaceCompactionTask ? -1 : 1;
        }
        if (o1 instanceof InnerSpaceCompactionTask) {
            return this.compareInnerSpaceCompactionTask((InnerSpaceCompactionTask)o1, (InnerSpaceCompactionTask)o2);
        }
        return this.compareCrossSpaceCompactionTask((CrossSpaceCompactionTask)o1, (CrossSpaceCompactionTask)o2);
    }

    @Override
    public int compareInnerSpaceCompactionTask(InnerSpaceCompactionTask o1, InnerSpaceCompactionTask o2) {
        double avgCompactionCount2;
        if (o1.getCompactionTaskType() != o2.getCompactionTaskType()) {
            return o1.getCompactionTaskType() == CompactionTaskType.REPAIR ? -1 : 1;
        }
        double avgCompactionCount1 = o1.getAvgCompactionCount();
        if (Math.abs(avgCompactionCount1 - (avgCompactionCount2 = o2.getAvgCompactionCount())) > 0.01) {
            return Double.compare(avgCompactionCount1, avgCompactionCount2);
        }
        if (o1.getTimePartition() != o2.getTimePartition()) {
            return o2.getTimePartition() > o1.getTimePartition() ? 1 : -1;
        }
        if (o1.getDataRegionId().equals(o2.getDataRegionId()) && o1.getTimePartition() == o2.getTimePartition() && o1.getMaxFileVersion() != o2.getMaxFileVersion()) {
            return o2.getMaxFileVersion() > o1.getMaxFileVersion() ? 1 : -1;
        }
        List<TsFileResource> selectedFilesOfO1 = o1.getSelectedTsFileResourceList();
        List<TsFileResource> selectedFilesOfO2 = o2.getSelectedTsFileResourceList();
        int fileNumDiff = Math.abs(selectedFilesOfO1.size() - selectedFilesOfO2.size());
        if (2 * fileNumDiff >= Math.min(selectedFilesOfO1.size(), selectedFilesOfO2.size())) {
            return selectedFilesOfO2.size() - selectedFilesOfO1.size();
        }
        return o2.getSelectedFileSize() > o1.getSelectedFileSize() ? -1 : 1;
    }

    @Override
    public int compareCrossSpaceCompactionTask(CrossSpaceCompactionTask o1, CrossSpaceCompactionTask o2) {
        if (o1.getTimePartition() != o2.getTimePartition()) {
            return o2.getTimePartition() > o1.getTimePartition() ? 1 : -1;
        }
        if (o1.getSelectedSequenceFiles().size() != o2.getSelectedSequenceFiles().size()) {
            return o1.getSelectedSequenceFiles().size() - o2.getSelectedSequenceFiles().size();
        }
        if (o1.getSerialId() != o2.getSerialId()) {
            return o1.getSerialId() > o2.getSerialId() ? 1 : -1;
        }
        return o2.getSelectedUnsequenceFiles().size() - o1.getSelectedUnsequenceFiles().size();
    }

    public int compareSettleCompactionTask(SettleCompactionTask o1, SettleCompactionTask o2) {
        if (o1.getFullyDirtyFiles().size() != o2.getFullyDirtyFiles().size()) {
            return o1.getFullyDirtyFiles().size() > o2.getFullyDirtyFiles().size() ? -1 : 1;
        }
        if (o1.getFullyDirtyFileSize() != o2.getFullyDirtyFileSize()) {
            return o1.getFullyDirtyFileSize() > o2.getFullyDirtyFileSize() ? -1 : 1;
        }
        if (o1.getTotalModsSize() != o2.getTotalModsSize()) {
            return o1.getTotalModsSize() > o2.getTotalModsSize() ? -1 : 1;
        }
        if (o1.getPartiallyDirtyFiles().size() != o2.getPartiallyDirtyFiles().size()) {
            return o1.getPartiallyDirtyFiles().size() > o2.getPartiallyDirtyFiles().size() ? -1 : 1;
        }
        if (o1.getPartiallyDirtyFileSize() != o2.getPartiallyDirtyFileSize()) {
            return o1.getPartiallyDirtyFileSize() > o2.getPartiallyDirtyFileSize() ? -1 : 1;
        }
        if (o1.getSerialId() != o2.getSerialId()) {
            return o1.getSerialId() < o2.getSerialId() ? -1 : 1;
        }
        return 0;
    }
}

