/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionWorker
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private final int threadId;
    private final FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue;

    public CompactionWorker(int threadId, FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue) {
        this.threadId = threadId;
        this.compactionTaskQueue = compactionTaskQueue;
    }

    @Override
    public void run() {
        while (true) {
            AbstractCompactionTask task;
            if (Thread.currentThread().isInterrupted()) {
                if (!CompactionTaskManager.getInstance().isStopAllCompactionWorker()) {
                    Thread.interrupted();
                    continue;
                }
                return;
            }
            try {
                task = this.compactionTaskQueue.take();
            }
            catch (InterruptedException e) {
                LOGGER.warn("CompactionThread-{} terminates because interruption", (Object)this.threadId);
                Thread.currentThread().interrupt();
                continue;
            }
            this.processOneCompactionTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOneCompactionTask(AbstractCompactionTask task) {
        if (task == null) {
            return true;
        }
        boolean taskSuccess = false;
        CompactionTaskType taskType = task.getCompactionTaskType();
        try {
            CompactionMetrics.getInstance().updateCompactionMemoryMetrics(taskType, task.getEstimatedMemoryCost());
            CompactionMetrics.getInstance().updateCompactionTaskSelectedFileNum(taskType, task.getAllSourceTsFiles().size());
            CompactionMetrics.getInstance().updateCompactionTaskSelectedFileSize(taskType, task.getSelectedFileSize());
            CompactionTaskSummary summary = task.getSummary();
            CompactionTaskFuture future = new CompactionTaskFuture(summary);
            CompactionTaskManager.getInstance().recordTask(task, future);
            taskSuccess = task.start();
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when executing compaction task. {}", (Object)task, (Object)e);
        }
        finally {
            if (taskSuccess) {
                task.getAllSourceTsFiles().forEach(AbstractCompactionEstimator::removeFileInfoFromGlobalFileInfoCache);
            }
        }
        return taskSuccess;
    }

    static class CompactionTaskFuture
    implements Future<CompactionTaskSummary> {
        CompactionTaskSummary summary;

        public CompactionTaskFuture(CompactionTaskSummary summary) {
            this.summary = summary;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.summary.cancel();
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.summary.isCancel();
        }

        @Override
        public boolean isDone() {
            return this.summary.isFinished();
        }

        @Override
        public CompactionTaskSummary get() throws InterruptedException, ExecutionException {
            while (!this.summary.isFinished()) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            return this.summary;
        }

        @Override
        public CompactionTaskSummary get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long perSleepTime = timeout < 100L ? timeout : 100L;
            long totalSleepTime = 0L;
            while (!this.summary.isFinished()) {
                if (totalSleepTime >= timeout) {
                    throw new TimeoutException("Timeout when trying to get compaction task summary");
                }
                unit.sleep(perSleepTime);
                totalSleepTime += perSleepTime;
            }
            return this.summary;
        }
    }
}

