/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractInnerCompactionWriter
extends AbstractCompactionWriter {
    protected CompactionTsFileWriter fileWriter;
    protected List<TsFileResource> targetResources;
    protected int currentFileIndex;
    protected long endedFileSize = 0L;
    protected final long memoryBudgetForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());

    protected AbstractInnerCompactionWriter(TsFileResource targetFileResource) {
        this(Collections.singletonList(targetFileResource));
    }

    protected AbstractInnerCompactionWriter(List<TsFileResource> targetFileResources) {
        this.targetResources = targetFileResources;
    }

    @Override
    public void startChunkGroup(IDeviceID deviceId, boolean isAlign) throws IOException {
        this.fileWriter = this.getAvailableWriter();
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    private CompactionTsFileWriter getAvailableWriter() throws IOException {
        boolean shouldSwitchToNextWriter;
        if (this.fileWriter == null) {
            this.fileWriter = new CompactionTsFileWriter(this.targetResources.get(this.currentFileIndex).getTsFile(), this.memoryBudgetForFileWriter, this.targetResources.get(this.currentFileIndex).isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);
            return this.fileWriter;
        }
        boolean bl = shouldSwitchToNextWriter = this.fileWriter.getPos() >= IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize() && this.currentFileIndex != this.targetResources.size() - 1;
        if (shouldSwitchToNextWriter) {
            this.rollCompactionFileWriter();
        }
        return this.fileWriter;
    }

    private void rollCompactionFileWriter() throws IOException {
        this.fileWriter.endFile();
        this.endedFileSize += this.fileWriter.getFile().length();
        if (this.fileWriter.isEmptyTargetFile()) {
            this.targetResources.get(this.currentFileIndex).forceMarkDeleted();
        }
        this.fileWriter = null;
        ++this.currentFileIndex;
        this.fileWriter = new CompactionTsFileWriter(this.targetResources.get(this.currentFileIndex).getTsFile(), this.memoryBudgetForFileWriter, this.targetResources.get(this.currentFileIndex).isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);
    }

    @Override
    public void endChunkGroup() throws IOException {
        CompactionUtils.updateResource(this.targetResources.get(this.currentFileIndex), this.fileWriter, this.deviceId);
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
    }

    @Override
    public void write(TimeValuePair timeValuePair, int subTaskId) throws IOException {
        this.checkPreviousTimestamp(timeValuePair.getTimestamp(), subTaskId);
        this.writeDataPoint(timeValuePair.getTimestamp(), timeValuePair.getValue(), this.chunkWriters[subTaskId]);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        this.lastTime[subTaskId] = timeValuePair.getTimestamp();
    }

    @Override
    public abstract void write(TsBlock var1, int var2) throws IOException;

    @Override
    public void endFile() throws IOException {
        for (int i = this.currentFileIndex + 1; i < this.targetResources.size(); ++i) {
            this.targetResources.get(i).forceMarkDeleted();
        }
        if (this.fileWriter == null || this.fileWriter.isEmptyTargetFile()) {
            this.targetResources.get(this.currentFileIndex).forceMarkDeleted();
            return;
        }
        this.fileWriter.endFile();
    }

    @Override
    public void close() throws Exception {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public void checkAndMayFlushChunkMetadata() throws IOException {
        this.fileWriter.checkMetadataSizeAndMayFlush();
    }

    @Override
    public long getWriterSize() throws IOException {
        return this.endedFileSize + (this.fileWriter == null ? 0L : this.fileWriter.getPos());
    }
}

