/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.DeviceSchemaFetchStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.SeriesSchemaFetchStatement;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

class ClusterSchemaFetchExecutor {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator;
    private final ITemplateManager templateManager;
    private final ISchemaFetcher schemaFetcher;
    private final Consumer<ClusterSchemaTree> schemaCacheUpdater;

    ClusterSchemaFetchExecutor(Coordinator coordinator, ITemplateManager templateManager, ISchemaFetcher schemaFetcher, Consumer<ClusterSchemaTree> schemaCacheUpdater) {
        this.coordinator = coordinator;
        this.templateManager = templateManager;
        this.schemaFetcher = schemaFetcher;
        this.schemaCacheUpdater = schemaCacheUpdater;
    }

    private ExecutionResult executionStatement(long queryId, Statement statement, MPPQueryContext context) {
        String sql;
        long timeout = context == null ? this.config.getQueryTimeoutThreshold() : context.getTimeOut();
        String string = sql = context == null ? "" : "Fetch Schema for " + (Object)((Object)context.getQueryType());
        if (context != null && context.getQueryType() == QueryType.READ) {
            sql = sql + ", " + context.getQueryId() + " : " + context.getSql();
        }
        return this.coordinator.executeForTreeModel(statement, queryId, context == null ? null : context.getSession(), sql, ClusterPartitionFetcher.getInstance(), this.schemaFetcher, timeout);
    }

    ClusterSchemaTree fetchSchemaOfFuzzyMatch(PathPatternTree patternTree, boolean withTags, boolean withTemplate, MPPQueryContext context) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        List pathPatternList = patternTree.getAllPathPatterns();
        for (PartialPath pattern : pathPatternList) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return this.executeSchemaFetchQuery(new SeriesSchemaFetchStatement(patternTree, templateMap, withTags, false, withTemplate, false), context);
    }

    ClusterSchemaTree fetchSchemaOfPreciseMatchOrPreciseDeviceUsingTemplate(List<PartialPath> fullPathList, PathPatternTree rawPatternTree, boolean withTemplate, MPPQueryContext context) {
        ClusterSchemaTree schemaTree = this.executeSchemaFetchQuery(new SeriesSchemaFetchStatement(rawPatternTree, this.analyzeTemplate(fullPathList), false, withTemplate, withTemplate, withTemplate), context);
        if (!schemaTree.isEmpty()) {
            this.schemaCacheUpdater.accept(schemaTree);
        }
        return schemaTree;
    }

    ClusterSchemaTree fetchDeviceLevelRawSchema(PathPatternTree patternTree, PathPatternTree authorityScope, MPPQueryContext context) {
        return this.executeSchemaFetchQuery(new DeviceSchemaFetchStatement(patternTree, authorityScope), context);
    }

    ClusterSchemaTree fetchMeasurementLevelRawSchema(PathPatternTree patternTree, MPPQueryContext context) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        List pathPatternList = patternTree.getAllPathPatterns();
        for (PartialPath pattern : pathPatternList) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return this.executeSchemaFetchQuery(new SeriesSchemaFetchStatement(patternTree, templateMap, true, true, false, true), context);
    }

    ClusterSchemaTree fetchSchemaOfOneDevice(PartialPath devicePath, String[] measurements, List<Integer> indexOfTargetMeasurements, MPPQueryContext context) {
        PathPatternTree patternTree = new PathPatternTree();
        for (int index : indexOfTargetMeasurements) {
            patternTree.appendFullPath(devicePath, measurements[index]);
        }
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree, context);
    }

    ClusterSchemaTree fetchSchemaOfMultiDevices(List<PartialPath> devicePathList, List<String[]> measurementsList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList, MPPQueryContext context) {
        PathPatternTree patternTree = new PathPatternTree();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            int deviceIndex = indexOfTargetDevices.get(i);
            for (int measurementIndex : indexOfTargetMeasurementsList.get(i)) {
                patternTree.appendFullPath(devicePathList.get(deviceIndex), measurementsList.get(deviceIndex)[measurementIndex]);
            }
        }
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree, context);
    }

    ClusterSchemaTree fetchSchemaWithFullPaths(List<String> fullPathList, MPPQueryContext context) {
        PathPatternTree patternTree = new PathPatternTree();
        for (String fullPath : fullPathList) {
            try {
                patternTree.appendFullPath(new PartialPath(fullPath));
            }
            catch (IllegalPathException e) {
                throw new RuntimeException(e);
            }
        }
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree, context);
    }

    ClusterSchemaTree fetchSchemaWithPatternTreeAndCache(PathPatternTree patternTree, MPPQueryContext context) {
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree, context);
    }

    private ClusterSchemaTree fetchSchemaAndCacheResult(PathPatternTree patternTree, MPPQueryContext context) {
        ClusterSchemaTree schemaTree = this.executeSchemaFetchQuery(new SeriesSchemaFetchStatement(patternTree, this.analyzeTemplate(patternTree.getAllPathPatterns()), false, false, true, false), context);
        if (!schemaTree.isEmpty()) {
            this.schemaCacheUpdater.accept(schemaTree);
        }
        return schemaTree;
    }

    private Map<Integer, Template> analyzeTemplate(List<PartialPath> pathPatternList) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (PartialPath pattern : pathPatternList) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return templateMap;
    }

    private ClusterSchemaTree executeSchemaFetchQuery(Statement fetchStatement, MPPQueryContext context) {
        long queryId = SessionManager.getInstance().requestQueryId();
        Throwable t = null;
        try {
            ExecutionResult executionResult = this.executionStatement(queryId, fetchStatement, context);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException(String.format("Fetch Schema failed, because %s", executionResult.status.getMessage()), executionResult.status.getCode()));
            }
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ClusterSchemaTree result = new ClusterSchemaTree();
                HashSet<String> databaseSet = new HashSet<String>();
                while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                    }
                    catch (IoTDBException e) {
                        t = e;
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        this.parseFetchedData(column.getBinary(i), result, databaseSet);
                    }
                }
                result.setDatabases(databaseSet);
                ClusterSchemaTree clusterSchemaTree = result;
                threadName.close();
                return clusterSchemaTree;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    t = throwable3;
                    throw throwable3;
                }
            }
        }
        finally {
            this.coordinator.cleanupQueryExecution(queryId, null, t);
        }
    }

    private void parseFetchedData(Binary data, ClusterSchemaTree resultSchemaTree, Set<String> databaseSet) {
        block5: {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getValues());
            try {
                byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
                if (type == 0) {
                    int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
                    for (int i = 0; i < size; ++i) {
                        databaseSet.add(ReadWriteIOUtils.readString((InputStream)inputStream));
                    }
                    break block5;
                }
                if (type == 1) {
                    resultSchemaTree.mergeSchemaTree(ClusterSchemaTree.deserialize(inputStream));
                    break block5;
                }
                throw new RuntimeException(new MetadataException("Failed to fetch schema because of unrecognized data"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

