/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SortKeyComparator;
import org.apache.iotdb.db.queryengine.plan.statement.component.NullOrdering;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.enums.TSDataType;

public class MergeSortComparator {
    private static final Comparator<SortKey> TIME_ASC_COMPARATOR = Comparator.comparingLong(sortKey -> sortKey.tsBlock.getTimeByIndex(sortKey.rowIndex));
    private static final Comparator<SortKey> TIME_DESC_COMPARATOR = Comparator.comparingLong(sortKey -> sortKey.tsBlock.getTimeByIndex(sortKey.rowIndex)).reversed();

    private MergeSortComparator() {
    }

    public static Comparator<SortKey> getComparator(List<SortItem> sortItemList, List<Integer> indexList, List<TSDataType> dataTypeList) {
        ArrayList<Comparator<SortKey>> list = new ArrayList<Comparator<SortKey>>(indexList.size());
        for (int i = 0; i < indexList.size(); ++i) {
            int index = indexList.get(i);
            if (index == -2) continue;
            TSDataType dataType = dataTypeList.get(i);
            boolean asc = sortItemList.get(i).getOrdering() == Ordering.ASC;
            boolean nullFirst = sortItemList.get(i).getNullOrdering() == NullOrdering.FIRST;
            list.add(MergeSortComparator.genSingleComparator(asc, index, dataType, nullFirst));
        }
        return list.size() == 1 ? (Comparator)list.get(0) : new ComparatorChain(list);
    }

    public static Comparator<SortKey> getComparator(TSDataType dataType, int index, boolean asc) {
        Comparator<SortKey> comparator;
        switch (dataType) {
            case INT32: {
                comparator = Comparator.comparingInt(sortKey -> sortKey.tsBlock.getColumn(index).getInt(sortKey.rowIndex));
                break;
            }
            case INT64: {
                comparator = Comparator.comparingLong(sortKey -> sortKey.tsBlock.getColumn(index).getLong(sortKey.rowIndex));
                break;
            }
            case FLOAT: {
                comparator = Comparator.comparingDouble(sortKey -> sortKey.tsBlock.getColumn(index).getFloat(sortKey.rowIndex));
                break;
            }
            case DOUBLE: {
                comparator = Comparator.comparingDouble(sortKey -> sortKey.tsBlock.getColumn(index).getDouble(sortKey.rowIndex));
                break;
            }
            case TEXT: {
                comparator = Comparator.comparing(sortKey -> sortKey.tsBlock.getColumn(index).getBinary(sortKey.rowIndex));
                break;
            }
            case BOOLEAN: {
                comparator = Comparator.comparing(sortKey -> sortKey.tsBlock.getColumn(index).getBoolean(sortKey.rowIndex));
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type: " + dataType + " cannot be ordered");
            }
        }
        if (!asc) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    private static Comparator<SortKey> genSingleComparator(boolean asc, int index, TSDataType dataType, boolean nullFirst) {
        if (index == -1) {
            return asc ? TIME_ASC_COMPARATOR : TIME_DESC_COMPARATOR;
        }
        return new SortKeyComparator(index, nullFirst, MergeSortComparator.getComparator(dataType, index, asc));
    }
}

