/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.transform.statement;

import java.time.ZoneId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.pipe.receiver.transform.converter.ValueConverter;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConvertedInsertRowStatement
extends InsertRowStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConvertedInsertRowStatement.class);

    public PipeConvertedInsertRowStatement(InsertRowStatement insertRowStatement) {
        this.isDebug = insertRowStatement.isDebug();
        insertRowStatement.removeAllFailedMeasurementMarks();
        this.devicePath = insertRowStatement.getDevicePath();
        this.isAligned = insertRowStatement.isAligned();
        this.measurementSchemas = insertRowStatement.getMeasurementSchemas();
        this.measurements = insertRowStatement.getMeasurements();
        this.dataTypes = insertRowStatement.getDataTypes();
        this.time = insertRowStatement.getTime();
        this.values = insertRowStatement.getValues();
        this.isNeedInferType = insertRowStatement.isNeedInferType();
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        LOGGER.info("Pipe: Inserting row to {}.{}. Casting type from {} to {}.", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
        this.values[columnIndex] = ValueConverter.convert(this.dataTypes[columnIndex], dataType, this.values[columnIndex]);
        this.dataTypes[columnIndex] = dataType;
        return true;
    }

    @Override
    public void transferType(ZoneId zoneId) throws QueryProcessException {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            if (this.measurementSchemas[i] == null) {
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw new QueryProcessException((IoTDBException)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i]));
                }
                this.markFailedMeasurement(i, (Exception)((Object)new QueryProcessException((IoTDBException)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i]))));
                continue;
            }
            this.dataTypes[i] = this.measurementSchemas[i].getType();
            try {
                this.values[i] = ValueConverter.parse(this.values[i].toString(), this.dataTypes[i]);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("data type of {}.{} is not consistent, registered type {}, inserting timestamp {}, value {}", new Object[]{this.devicePath, this.measurements[i], this.dataTypes[i], this.time, this.values[i]});
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw e;
                }
                this.markFailedMeasurement(i, e);
            }
        }
        this.isNeedInferType = false;
    }
}

