/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResourceManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeResourceMetrics
implements IMetricSet {
    private static final String PIPE_USED_MEMORY = "PipeUsedMemory";
    private static final String PIPE_TOTAL_MEMORY = "PipeTotalMemory";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), PipeMemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), PIPE_USED_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), PipeMemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), PIPE_TOTAL_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_PINNED_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.wal(), PipeWALResourceManager::getPinnedWalCount, new String[0]);
        metricService.createAutoGauge(Metric.PIPE_LINKED_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.tsfile(), PipeTsFileResourceManager::getLinkedTsfileCount, new String[0]);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_USED_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_TOTAL_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_PINNED_MEMTABLE_COUNT.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_LINKED_TSFILE_COUNT.toString(), new String[0]);
    }

    public static PipeResourceMetrics getInstance() {
        return PipeResourceMetricsHolder.INSTANCE;
    }

    private PipeResourceMetrics() {
    }

    private static class PipeResourceMetricsHolder {
        private static final PipeResourceMetrics INSTANCE = new PipeResourceMetrics();

        private PipeResourceMetricsHolder() {
        }
    }
}

