/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner;

import com.lmax.disruptor.EventHandler;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEventFactory;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.DisruptorQueue;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTimePartitionProgressIndexKeeper;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.matcher.CachedSchemaPatternMatcher;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.matcher.PipeDataRegionMatcher;
import org.apache.iotdb.db.pipe.metric.PipeAssignerMetrics;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataRegionAssigner
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataRegionAssigner.class);
    private static final int nonForwardingEventsProgressReportInterval = PipeConfig.getInstance().getPipeNonForwardingEventsProgressReportInterval();
    private final PipeDataRegionMatcher matcher;
    private final DisruptorQueue disruptor;
    private final String dataRegionId;
    private int counter = 0;
    private final AtomicReference<ProgressIndex> maxProgressIndexForTsFileInsertionEvent = new AtomicReference<MinimumProgressIndex>(MinimumProgressIndex.INSTANCE);

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public PipeDataRegionAssigner(String dataRegionId) {
        this.matcher = new CachedSchemaPatternMatcher();
        this.disruptor = new DisruptorQueue((EventHandler<PipeRealtimeEvent>)((EventHandler)this::assignToExtractor));
        this.dataRegionId = dataRegionId;
        PipeAssignerMetrics.getInstance().register(this);
    }

    public void publishToAssign(PipeRealtimeEvent event) {
        if (!event.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
            LOGGER.warn("The reference count of the realtime event {} cannot be increased, skipping it.", (Object)event);
            return;
        }
        this.disruptor.publish(event);
        if (event.getEvent() instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event.getEvent()).onPublished();
        }
    }

    public void assignToExtractor(PipeRealtimeEvent event, long sequence, boolean endOfBatch) {
        this.matcher.match(event).forEach(extractor -> {
            if (event.getEvent().isGeneratedByPipe() && !extractor.isForwardingPipeRequests()) {
                if (!(event.getEvent() instanceof TsFileInsertionEvent)) {
                    if (this.counter < nonForwardingEventsProgressReportInterval) {
                        ++this.counter;
                        return;
                    }
                    this.counter = 0;
                }
                ProgressReportEvent reportEvent = new ProgressReportEvent(extractor.getPipeName(), extractor.getCreationTime(), extractor.getPipeTaskMeta(), extractor.getPipePattern(), extractor.getRealtimeDataExtractionStartTime(), extractor.getRealtimeDataExtractionEndTime());
                reportEvent.bindProgressIndex(event.getProgressIndex());
                if (!reportEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
                    LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)reportEvent);
                    return;
                }
                extractor.extract(PipeRealtimeEventFactory.createRealtimeEvent(reportEvent));
                return;
            }
            PipeRealtimeEvent copiedEvent = event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(extractor.getPipeName(), extractor.getCreationTime(), extractor.getPipeTaskMeta(), extractor.getPipePattern(), extractor.getRealtimeDataExtractionStartTime(), extractor.getRealtimeDataExtractionEndTime());
            EnrichedEvent innerEvent = copiedEvent.getEvent();
            if (innerEvent instanceof PipeTsFileInsertionEvent) {
                PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)innerEvent;
                tsFileInsertionEvent.disableMod4NonTransferPipes(extractor.isShouldTransferModFile());
                this.bindOrUpdateProgressIndexForTsFileInsertionEvent(tsFileInsertionEvent);
            }
            if (!copiedEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)copiedEvent);
                return;
            }
            extractor.extract(copiedEvent);
            if (innerEvent instanceof PipeHeartbeatEvent) {
                ((PipeHeartbeatEvent)innerEvent).onAssigned();
            }
        });
        event.gcSchemaInfo();
        event.decreaseReferenceCount(PipeDataRegionAssigner.class.getName(), false);
    }

    private void bindOrUpdateProgressIndexForTsFileInsertionEvent(PipeTsFileInsertionEvent event) {
        if (PipeTimePartitionProgressIndexKeeper.getInstance().isProgressIndexAfterOrEquals(this.dataRegionId, event.getTimePartitionId(), event.getProgressIndex())) {
            event.bindProgressIndex(this.maxProgressIndexForTsFileInsertionEvent.get());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Data region {} bind {} to event {} because it was flushed prematurely.", new Object[]{this.dataRegionId, this.maxProgressIndexForTsFileInsertionEvent, event.coreReportMessage()});
            }
        } else {
            this.maxProgressIndexForTsFileInsertionEvent.updateAndGet(index -> index.updateToMinimumEqualOrIsAfterProgressIndex(event.getProgressIndex()));
        }
    }

    public void startAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.register(extractor);
    }

    public void stopAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.deregister(extractor);
    }

    public boolean notMoreExtractorNeededToBeAssigned() {
        return this.matcher.getRegisterCount() == 0;
    }

    @Override
    public void close() {
        PipeAssignerMetrics.getInstance().deregister(this.dataRegionId);
        this.matcher.clear();
        this.disruptor.clear();
    }

    public int getTabletInsertionEventCount() {
        return this.disruptor.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.disruptor.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.disruptor.getPipeHeartbeatEventCount();
    }
}

