/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterTopicPlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTopicProcedure
extends AbstractOperateSubscriptionProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterTopicProcedure.class);
    private TopicMeta updatedTopicMeta;
    private TopicMeta existedTopicMeta;

    public AlterTopicProcedure() {
    }

    public AlterTopicProcedure(TopicMeta updatedTopicMeta) {
        this.updatedTopicMeta = updatedTopicMeta;
    }

    public AlterTopicProcedure(TopicMeta updatedTopicMeta, AtomicReference<SubscriptionInfo> subscriptionInfo) {
        this.updatedTopicMeta = updatedTopicMeta;
        this.subscriptionInfo = subscriptionInfo;
    }

    public TopicMeta getExistedTopicMeta() {
        return this.existedTopicMeta;
    }

    public TopicMeta getUpdatedTopicMeta() {
        return this.updatedTopicMeta;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.ALTER_TOPIC;
    }

    @Override
    public boolean executeFromValidate(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("AlterTopicProcedure: executeFromValidate");
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeAlteringTopic(this.updatedTopicMeta);
        this.existedTopicMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).getTopicMeta(this.updatedTopicMeta.getTopicName());
        return true;
    }

    @Override
    public void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("AlterTopicProcedure: executeFromOperateOnConfigNodes, try to alter topic");
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterTopicPlan(this.updatedTopicMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.ALTER_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to alter topic (%s -> %s) on config nodes, because %s", this.existedTopicMeta, this.updatedTopicMeta, response));
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("AlterTopicProcedure: executeFromOperateOnDataNodes({})", (Object)this.updatedTopicMeta.getTopicName());
        try {
            List<TSStatus> statuses = env.pushSingleTopicOnDataNode(this.updatedTopicMeta.serialize());
            if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new SubscriptionException(String.format("Failed to alter topic (%s -> %s) on data nodes, because %s", this.existedTopicMeta, this.updatedTopicMeta, statuses));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize the topic meta due to: ", (Throwable)e);
            throw new SubscriptionException(String.format("Failed to alter topic (%s -> %s) on data nodes, because %s", this.existedTopicMeta, this.updatedTopicMeta, e.getMessage()));
        }
    }

    @Override
    public void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterTopicProcedure: rollbackFromValidate({})", (Object)this.updatedTopicMeta.getTopicName());
    }

    @Override
    public void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("AlterTopicProcedure: rollbackFromOperateOnConfigNodes({})", (Object)this.updatedTopicMeta.getTopicName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterTopicPlan(this.existedTopicMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.ALTER_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to rollback from altering topic (%s -> %s) on config nodes, because %s", this.updatedTopicMeta, this.existedTopicMeta, response));
        }
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterTopicProcedure: rollbackFromOperateOnDataNodes({})", (Object)this.updatedTopicMeta.getTopicName());
        try {
            List<TSStatus> statuses = env.pushSingleTopicOnDataNode(this.existedTopicMeta.serialize());
            if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new SubscriptionException(String.format("Failed to rollback from altering topic (%s -> %s) on data nodes, because %s", this.updatedTopicMeta, this.existedTopicMeta, statuses));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize the topic meta due to: ", (Throwable)e);
            throw new SubscriptionException(String.format("Failed to rollback from altering topic (%s -> %s) on data nodes, because %s", this.updatedTopicMeta, this.existedTopicMeta, e.getMessage()));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ALTER_TOPIC_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)(this.updatedTopicMeta != null ? 1 : 0), (OutputStream)stream);
        if (this.updatedTopicMeta != null) {
            this.updatedTopicMeta.serialize((OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)(this.existedTopicMeta != null ? 1 : 0), (OutputStream)stream);
        if (this.existedTopicMeta != null) {
            this.existedTopicMeta.serialize((OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.updatedTopicMeta = TopicMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.existedTopicMeta = TopicMeta.deserialize((ByteBuffer)byteBuffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterTopicProcedure that = (AlterTopicProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && this.getCycles() == that.getCycles() && Objects.equals(this.updatedTopicMeta, that.updatedTopicMeta) && Objects.equals(this.existedTopicMeta, that.existedTopicMeta);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.updatedTopicMeta, this.existedTopicMeta);
    }
}

