/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.SetTTLState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTTLProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, SetTTLState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTTLProcedure.class);
    private SetTTLPlan plan;

    public SetTTLProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public SetTTLProcedure(SetTTLPlan plan, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.plan = plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, SetTTLState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case SET_CONFIGNODE_TTL: {
                    this.setConfigNodeTTL(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
                    return flow;
                }
                case UPDATE_DATANODE_CACHE: {
                    this.updateDataNodeTTL(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("SetTTL-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void setConfigNodeTTL(ConfigNodeProcedureEnv env) {
        TSStatus res;
        try {
            res = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(this.plan) : this.plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
        }
        if (res.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.info("Failed to execute plan {} because {}", (Object)this.plan, (Object)res.message);
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(res.message, res.code)));
        } else {
            this.setNextState(SetTTLState.UPDATE_DATANODE_CACHE);
        }
    }

    private void updateDataNodeTTL(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.SET_TTL, new TSetTTLReq(Collections.singletonList(String.join((CharSequence)".", this.plan.getPathPattern())), this.plan.getTTL(), this.plan.isDataBase()), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to update ttl cache of dataNode.");
            this.setFailure(new ProcedureException(new MetadataException("Update dataNode ttl cache failed")));
            return;
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, SetTTLState setTTLState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected SetTTLState getState(int stateId) {
        return SetTTLState.values()[stateId];
    }

    @Override
    protected int getStateId(SetTTLState setTTLState) {
        return setTTLState.ordinal();
    }

    @Override
    protected SetTTLState getInitialState() {
        return SetTTLState.SET_CONFIGNODE_TTL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_SET_TTL_PROCEDURE.getTypeCode() : ProcedureType.SET_TTL_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((ByteBuffer)this.plan.serializeToByteBuffer(), (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            this.plan = (SetTTLPlan)ConfigPhysicalPlan.Factory.create(byteBuffer);
        }
        catch (IOException e) {
            LOGGER.error("IO error when deserialize setTTL plan.", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.plan.equals(((SetTTLProcedure)o).plan) && this.isGeneratedByPipe == ((SetTTLProcedure)o).isGeneratedByPipe;
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.isGeneratedByPipe);
    }
}

