/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateResp;
import org.apache.iotdb.rpc.TSStatusCode;

public class SchemaUtils {
    public static boolean checkDataNodeTemplateActivation(ConfigManager configManager, final PathPatternTree patternTree, final Template template) throws MetadataException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteBuffer patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = configManager.getRelatedSchemaRegionGroup(patternTree);
        final ArrayList respList = new ArrayList();
        final MetadataException[] exception = new MetadataException[]{null};
        DataNodeRegionTaskExecutor<TCountPathsUsingTemplateReq, TCountPathsUsingTemplateResp> regionTask = new DataNodeRegionTaskExecutor<TCountPathsUsingTemplateReq, TCountPathsUsingTemplateResp>(configManager, relatedSchemaRegionGroup, false, CnToDnRequestType.COUNT_PATHS_USING_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TCountPathsUsingTemplateReq(template.getId(), patternTreeBytes, consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCountPathsUsingTemplateResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                exception[0] = new MetadataException(String.format("Failed to execute in all replicaset of schemaRegion %s when checking the template %s on %s. Failure nodes: %s", consensusGroupId.id, template, patternTree, dataNodeLocationSet));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (exception[0] != null) {
            throw exception[0];
        }
        for (TCountPathsUsingTemplateResp resp : respList) {
            if (resp.count <= 0L) continue;
            return true;
        }
        return false;
    }

    public static void checkSchemaRegionUsingTemplate(ConfigManager configManager, final List<PartialPath> deleteDatabasePatternPaths) throws MetadataException {
        PathPatternTree deleteDatabasePatternTree = new PathPatternTree();
        for (PartialPath path : deleteDatabasePatternPaths) {
            deleteDatabasePatternTree.appendPathPattern(path);
        }
        deleteDatabasePatternTree.constructTree();
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = configManager.getRelatedSchemaRegionGroup(deleteDatabasePatternTree);
        final ArrayList respList = new ArrayList();
        final MetadataException[] exception = new MetadataException[]{null};
        DataNodeRegionTaskExecutor<TCheckSchemaRegionUsingTemplateReq, TCheckSchemaRegionUsingTemplateResp> regionTask = new DataNodeRegionTaskExecutor<TCheckSchemaRegionUsingTemplateReq, TCheckSchemaRegionUsingTemplateResp>(configManager, relatedSchemaRegionGroup, false, CnToDnRequestType.CHECK_SCHEMA_REGION_USING_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TCheckSchemaRegionUsingTemplateReq(consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCheckSchemaRegionUsingTemplateResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                exception[0] = new MetadataException(String.format("Failed to execute in all replicaset of schemaRegion %s when checking templates on path %s. Failure nodes: %s", consensusGroupId.id, deleteDatabasePatternPaths, dataNodeLocationSet));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (exception[0] != null) {
            throw exception[0];
        }
        for (TCheckSchemaRegionUsingTemplateResp resp : respList) {
            if (!resp.result) continue;
            throw new PathNotExistException(deleteDatabasePatternPaths.stream().map(PartialPath::getFullPath).collect(Collectors.toList()), false);
        }
    }
}

