/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.event;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigSerializableEventType;
import org.apache.iotdb.confignode.manager.pipe.resource.PipeConfigNodeResourceManager;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigRegionSnapshotEvent
extends PipeSnapshotEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigRegionSnapshotEvent.class);
    private String snapshotPath;
    private String templateFilePath;
    private static final Map<CNSnapshotFileType, Set<Short>> SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP = new EnumMap<CNSnapshotFileType, Set<Short>>(CNSnapshotFileType.class);
    private CNSnapshotFileType fileType;

    public PipeConfigRegionSnapshotEvent() {
        this(null, null, null);
    }

    public PipeConfigRegionSnapshotEvent(String snapshotPath, String templateFilePath, CNSnapshotFileType type) {
        this(snapshotPath, templateFilePath, type, null, 0L, null, null);
    }

    public PipeConfigRegionSnapshotEvent(String snapshotPath, String templateFilePath, CNSnapshotFileType type, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern) {
        super(pipeName, creationTime, pipeTaskMeta, pattern, PipeConfigNodeResourceManager.snapshot());
        this.snapshotPath = snapshotPath;
        this.templateFilePath = Objects.nonNull(templateFilePath) ? templateFilePath : "";
        this.fileType = type;
    }

    public File getSnapshotFile() {
        return new File(this.snapshotPath);
    }

    public File getTemplateFile() {
        return !this.templateFilePath.isEmpty() ? new File(this.templateFilePath) : null;
    }

    public CNSnapshotFileType getFileType() {
        return this.fileType;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.snapshotPath = this.resourceManager.increaseSnapshotReference(this.snapshotPath);
            if (!this.templateFilePath.isEmpty()) {
                this.templateFilePath = this.resourceManager.increaseSnapshotReference(this.templateFilePath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for snapshot %s error. Holder Message: %s", this.snapshotPath, holderMessage), (Throwable)e);
            return false;
        }
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            this.resourceManager.decreaseSnapshotReference(this.snapshotPath);
            if (!this.templateFilePath.isEmpty()) {
                this.resourceManager.decreaseSnapshotReference(this.templateFilePath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for snapshot %s error. Holder Message: %s", this.snapshotPath, holderMessage), (Throwable)e);
            return false;
        }
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeConfigRegionSnapshotEvent(this.snapshotPath, this.templateFilePath, this.fileType, pipeName, creationTime, pipeTaskMeta, pattern);
    }

    public ByteBuffer serializeToByteBuffer() {
        ByteBuffer result = ByteBuffer.allocate(10 + this.snapshotPath.getBytes().length + this.templateFilePath.getBytes().length);
        ReadWriteIOUtils.write((byte)PipeConfigSerializableEventType.CONFIG_SNAPSHOT.getType(), (ByteBuffer)result);
        ReadWriteIOUtils.write((byte)this.fileType.getType(), (ByteBuffer)result);
        ReadWriteIOUtils.write((String)this.snapshotPath, (ByteBuffer)result);
        ReadWriteIOUtils.write((String)this.templateFilePath, (ByteBuffer)result);
        return result;
    }

    public void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.fileType = CNSnapshotFileType.deserialize(ReadWriteIOUtils.readByte((ByteBuffer)buffer));
        this.snapshotPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.templateFilePath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    public static boolean needTransferSnapshot(Set<ConfigPhysicalPlanType> listenedTypeSet) {
        Set types = SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        types.retainAll(listenedTypeSet.stream().map(ConfigPhysicalPlanType::getPlanType).collect(Collectors.toSet()));
        return !types.isEmpty();
    }

    public void confineTransferredTypes(Set<ConfigPhysicalPlanType> listenedTypeSet) {
        HashSet types = new HashSet(SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.get((Object)this.fileType));
        types.retainAll(listenedTypeSet.stream().map(ConfigPhysicalPlanType::getPlanType).collect(Collectors.toSet()));
        this.transferredTypes = types;
    }

    public static Set<ConfigPhysicalPlanType> getConfigPhysicalPlanTypeSet(String sealTypes) {
        return sealTypes.isEmpty() ? Collections.emptySet() : Arrays.stream(sealTypes.split(",")).map(typeValue -> ConfigPhysicalPlanType.convertToConfigPhysicalPlanType(Short.parseShort(typeValue))).collect(Collectors.toSet());
    }

    public String toString() {
        return String.format("PipeConfigRegionSnapshotEvent{snapshotPath=%s, templateFilePath=%s, fileType=%s}", new Object[]{this.snapshotPath, this.templateFilePath, this.fileType}) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeConfigRegionSnapshotEvent{snapshotPath=%s, templateFilePath=%s, fileType=%s}", new Object[]{this.snapshotPath, this.templateFilePath, this.fileType}) + " - " + super.coreReportMessage();
    }

    static {
        SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.put(CNSnapshotFileType.ROLE, Collections.unmodifiableSet(new HashSet<Short>(Arrays.asList(ConfigPhysicalPlanType.CreateRole.getPlanType(), ConfigPhysicalPlanType.GrantRole.getPlanType()))));
        SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.put(CNSnapshotFileType.USER, Collections.unmodifiableSet(new HashSet<Short>(Arrays.asList(ConfigPhysicalPlanType.CreateUserWithRawPassword.getPlanType(), ConfigPhysicalPlanType.GrantUser.getPlanType()))));
        SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.put(CNSnapshotFileType.USER_ROLE, Collections.singleton(ConfigPhysicalPlanType.GrantRoleToUser.getPlanType()));
        SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.put(CNSnapshotFileType.SCHEMA, Collections.unmodifiableSet(new HashSet<Short>(Arrays.asList(ConfigPhysicalPlanType.CreateDatabase.getPlanType(), ConfigPhysicalPlanType.CreateSchemaTemplate.getPlanType(), ConfigPhysicalPlanType.CommitSetSchemaTemplate.getPlanType()))));
        SNAPSHOT_FILE_TYPE_2_CONFIG_PHYSICAL_PLAN_TYPE_MAP.put(CNSnapshotFileType.TTL, Collections.singleton(ConfigPhysicalPlanType.SetTTL.getPlanType()));
    }
}

