/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.heartbeat;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;

public class PipeHeartbeat {
    private final Map<PipeStaticMeta, PipeMeta> pipeMetaMap = new HashMap<PipeStaticMeta, PipeMeta>();
    private final Map<PipeStaticMeta, Boolean> isCompletedMap = new HashMap<PipeStaticMeta, Boolean>();
    private final Map<PipeStaticMeta, Long> remainingEventCountMap = new HashMap<PipeStaticMeta, Long>();
    private final Map<PipeStaticMeta, Double> remainingTimeMap = new HashMap<PipeStaticMeta, Double>();

    public PipeHeartbeat(@NotNull List<ByteBuffer> pipeMetaByteBufferListFromAgent, List<Boolean> pipeCompletedListFromAgent, List<Long> pipeRemainingEventCountListFromAgent, List<Double> pipeRemainingTimeListFromAgent) {
        for (int i = 0; i < pipeMetaByteBufferListFromAgent.size(); ++i) {
            PipeMeta pipeMeta = PipeMeta.deserialize((ByteBuffer)pipeMetaByteBufferListFromAgent.get(i));
            this.pipeMetaMap.put(pipeMeta.getStaticMeta(), pipeMeta);
            this.isCompletedMap.put(pipeMeta.getStaticMeta(), Objects.nonNull(pipeCompletedListFromAgent) && pipeCompletedListFromAgent.get(i) != false);
            this.remainingEventCountMap.put(pipeMeta.getStaticMeta(), Objects.nonNull(pipeCompletedListFromAgent) ? pipeRemainingEventCountListFromAgent.get(i) : 0L);
            this.remainingTimeMap.put(pipeMeta.getStaticMeta(), Objects.nonNull(pipeRemainingTimeListFromAgent) ? pipeRemainingTimeListFromAgent.get(i) : 0.0);
        }
    }

    public int getPipeMetaSize() {
        return this.pipeMetaMap.size();
    }

    public PipeMeta getPipeMeta(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMetaMap.get(pipeStaticMeta);
    }

    public Boolean isCompleted(PipeStaticMeta pipeStaticMeta) {
        return this.isCompletedMap.get(pipeStaticMeta);
    }

    public Long getRemainingEventCount(PipeStaticMeta pipeStaticMeta) {
        return this.remainingEventCountMap.get(pipeStaticMeta);
    }

    public Double getRemainingTime(PipeStaticMeta pipeStaticMeta) {
        return this.remainingTimeMap.get(pipeStaticMeta);
    }

    public boolean isEmpty() {
        return this.pipeMetaMap.isEmpty();
    }
}

